/*
 * Created on Feb 10, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;

/**
 * Marker interface indicating that the implementing interface is a source of the
 * {@link RefreshEvent} event.
 * 
 * @author Vijay Silva
 */
public interface HasRefreshHandlers extends HasHandlers {

	/**
	 * Adds a event handler for the {@link RefreshEvent} event.
	 * 
	 * @param handler the handler
	 * @return the registration for the event
	 */
	HandlerRegistration addRefreshHandler(RefreshHandler handler);
}
