/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.application.event;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;

/**
 * Event to handle the application 'show user guide' event
 * 
 * @author Vijay Silva
 */
public class ShowUserGuideEvent extends GwtEvent<ShowUserGuideHandler> {

	/* The Handler type */
	private static Type<ShowUserGuideHandler> TYPE;

	/* The application */
	private NeptuneApplication application;

	/**
	 * Constructor
	 * 
	 * @param application The application firing the event
	 */
	public ShowUserGuideEvent(NeptuneApplication application) {
		this.application = application;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ShowUserGuideHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<ShowUserGuideHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<ShowUserGuideHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ShowUserGuideHandler handler) {
		handler.onShowUserGuide(this);
	}

	/**
	 * @return the application
	 */
	public NeptuneApplication getApplication() {
		return application;
	}
}
