/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.userprefmgmt.ejb;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.realm.persist.UserPreference;
import com.tandbergtv.neptune.userprefmgmt.service.IUserPreferenceManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Local(value={IUserPreferenceManager.class})
@Stateless
public class UserPreferenceManager
implements IUserPreferenceManager {
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public UserPreference create(UserPreference userPreference) {
        userPreference.setUserName(this.authorizationService.getUserName());
        this.entityManager.persist((Object)userPreference);
        this.entityManager.flush();
        return userPreference;
    }

    public List<UserPreference> create(List<UserPreference> userPreferences) {
        if (userPreferences != null) {
            for (UserPreference userPreference : userPreferences) {
                userPreference.setUserName(this.authorizationService.getUserName());
                this.entityManager.persist((Object)userPreference);
            }
            this.entityManager.flush();
        }
        return userPreferences;
    }

    public UserPreference save(UserPreference userPreference) {
        this.entityManager.merge((Object)userPreference);
        this.entityManager.flush();
        return userPreference;
    }

    public UserPreference getPreference(Long id) {
        return (UserPreference)this.entityManager.find(UserPreference.class, (Object)id);
    }

    public List<UserPreference> getPreferences(String component) {
        Query query = this.entityManager.createNamedQuery("UserPref.FindByComponent");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        return query.getResultList();
    }

    public List<UserPreference> getPreferences(String component, String type) {
        Query query = this.entityManager.createNamedQuery("UserPref.FindByComponentAndType");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public UserPreference getPreference(String component, String type, String key) {
        Query query = this.entityManager.createNamedQuery("UserPref.FindByComponentAndTypeAndKey");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.setParameter("type", (Object)type);
        query.setParameter("key", (Object)key);
        UserPreference userPreference = null;
        try {
            userPreference = (UserPreference)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return userPreference;
    }

    public void deletePreference(Long id) {
        Query query = this.entityManager.createNamedQuery("UserPref.DeleteById");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("id", (Object)id);
        query.executeUpdate();
        this.entityManager.flush();
    }

    public void deletePreferences(String component) {
        Query query = this.entityManager.createNamedQuery("UserPref.DeleteByComponent");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.executeUpdate();
        this.entityManager.flush();
    }

    public void deletePreferences(String component, String type) {
        Query query = this.entityManager.createNamedQuery("UserPref.DeleteByComponentAndType");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.setParameter("type", (Object)type);
        query.executeUpdate();
        this.entityManager.flush();
    }

    public void deletePreference(String component, String type, String key) {
        Query query = this.entityManager.createNamedQuery("UserPref.DeleteByComponentAndTypeAndKey");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.setParameter("type", (Object)type);
        query.setParameter("key", (Object)key);
        query.executeUpdate();
        this.entityManager.flush();
    }
}

