/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.actionItems.cache;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import com.tandbergtv.neptune.actionItems.cache.IDistributedCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class DistributedCache<T>
implements IDistributedCache<T> {
    private String name;
    private IMap<Serializable, T> map;
    private IClusterService clusterService;
    private static final Logger logger = Logger.getLogger(DistributedCache.class);

    public DistributedCache(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public DistributedCache(String name, int size) {
        this.name = name;
        MapConfig config = new MapConfig(name);
        config.getMaxSizeConfig().setSize(size);
        config.setEvictionPolicy(EvictionPolicy.LRU);
        this.getClusterService().getInstance().getConfig().addMapConfig(config);
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
        this.map = this.getClusterService().getInstance().getMap(this.name);
        this.registerMigrationListener();
    }

    @Override
    public void stop() {
    }

    @Override
    public T get(Serializable key) {
        return (T)this.map.get((Object)key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.map.keySet();
    }

    @Override
    public void add(Serializable key, T entity) {
        if (key == null || entity == null) {
            throw new IllegalArgumentException();
        }
        long start = System.currentTimeMillis();
        this.map.put((Object)key, entity);
        logger.debug((Object)("Time taken to DistributedCache().add() - time:" + (System.currentTimeMillis() - start)));
    }

    @Override
    public void remove(Serializable key) {
        long start = System.currentTimeMillis();
        this.map.remove((Object)key);
        logger.debug((Object)("Time taken to DistributedCache().remove() - time:" + (System.currentTimeMillis() - start)));
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public Collection<Serializable> localKeySet() {
        return this.map.localKeySet();
    }

    @Override
    public ConcurrentMap<Serializable, T> getMap() {
        return this.map;
    }

    protected void registerMigrationListener() {
        this.getClusterService().getInstance().getPartitionService().addMigrationListener(this.getMigrationListener());
    }

    protected MigrationListener getMigrationListener() {
        return new CacheKeyMigrationListener(this);
    }

    protected Set<Serializable> getLocalKeysInPartition(int partitionId) {
        HashSet<Serializable> set = new HashSet<Serializable>();
        for (Serializable key : this.localKeySet()) {
            if (this.getClusterService().getPartitionId((Object)key) != partitionId) continue;
            set.add(key);
        }
        return set;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        }
        return this.clusterService;
    }

    protected class CacheKeyMigrationListener
    implements MigrationListener {
        protected final IDistributedCache<T> cache;

        public CacheKeyMigrationListener(IDistributedCache<T> cache) {
            this.cache = cache;
        }

        public void migrationStarted(MigrationEvent event) {
        }

        public void migrationCompleted(MigrationEvent event) {
        }

        protected boolean wasPreviousOwner(MigrationEvent me) {
            return DistributedCache.this.getClusterService().getLocalMember().equals(me.getOldOwner());
        }

        protected boolean isNewOwner(MigrationEvent me) {
            return DistributedCache.this.getClusterService().getLocalMember().equals(me.getNewOwner());
        }

        public void migrationFailed(MigrationEvent migrationEvent) {
        }
    }
}

