/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import com.ericsson.cms.neptune.cluster.config.AbstractConfigBuilder;
import com.ericsson.cms.neptune.cluster.util.AdvancedProperties;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.TcpIpConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfigBuilder
extends AbstractConfigBuilder<Config> {
    private static final Logger LOGGER = Logger.getLogger(ConfigBuilder.class);
    private static final String CLUSTER_NEPTUNE = "/opt/tandbergtv/cms/conf/neptune/cluster.properties";
    private static final String CLUSTER_NEPTUNE_OAUTH = "/opt/tandbergtv/cms/conf/neptune/oauthCluster.properties";
    private static final String CLUSTER_WORKFLOW = "/opt/tandbergtv/cms/conf/workflow/cluster.properties";
    private static final String CLUSTER_WATCHFOLDER = "/opt/tandbergtv/cms/conf/watchfolder/cluster.properties";
    private static final String CLUSTER_EPG = "/opt/tandbergtv/cms/conf/epgmgmt/hazelcast-epg.properties";
    private String xmlConfigPathKey = "xml.config.path";

    public ConfigBuilder(String configFile) {
        super(configFile);
    }

    public ConfigBuilder xmlConfigPathKey(String xmlConfigPathKey) {
        this.xmlConfigPathKey = xmlConfigPathKey;
        return this;
    }

    private Config create(AdvancedProperties properties) throws IOException {
        String xmlPath = properties.getProperty(this.xmlConfigPathKey);
        if (xmlPath != null) {
            FileSystemXmlConfig cfg = new FileSystemXmlConfig(xmlPath);
            return cfg;
        }
        ClasspathXmlConfig config = null;
        try {
            config = new ClasspathXmlConfig(ConfigBuilder.class.getClassLoader(), "com/ericsson/cms/neptune/cluster/config/hazelcast-datastructure.xml");
        }
        catch (Exception e) {
            LOGGER.warn((Object)("cannot read internal data structure configuration, use default, error: " + e));
            config = new Config();
        }
        this.configureClusterDiscovery((Config)config, properties);
        this.configurePort(properties, (Config)config);
        this.configureInterfaces((Config)config, properties);
        this.configureClusterName((Config)config, properties);
        this.configureInitialWait((Config)config, properties);
        return config;
    }

    private void configurePort(AdvancedProperties properties, Config config) {
        String autoIncrementStr;
        int port = properties.getInt(this.portKey, this.defaultPort);
        if (port > -1) {
            config.getNetworkConfig().setPort(port);
        }
        if (StringUtils.isNotBlank((String)(autoIncrementStr = properties.getProperty(this.autoIncrementKey)))) {
            this.isPortAutoIncrement = Boolean.parseBoolean(autoIncrementStr);
        }
        config.getNetworkConfig().setPortAutoIncrement(this.isPortAutoIncrement);
    }

    private void configureInitialWait(Config config, Properties properties) throws IOException {
        String wait = properties.getProperty(this.initialWaitKey);
        if (StringUtils.isNotBlank((String)wait)) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private void configureClusterName(Config config, Properties properties) throws IOException {
        String password;
        String name = properties.getProperty(this.clusterNameKey);
        if (name != null) {
            LOGGER.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(this.clusterPasswordKey)) != null) {
            config.getGroupConfig().setPassword(password);
        }
    }

    private void configureInterfaces(Config config, Properties properties) throws IOException {
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(this.hostKey);
        String netInterface = properties.getProperty(this.interfaceKey);
        if (!StringUtils.isBlank((String)host)) {
            StringTokenizer stringTokenizer = new StringTokenizer(host, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken().trim();
                if (!StringUtils.isNotBlank((String)token)) continue;
                config.getNetworkConfig().getInterfaces().addInterface(token);
                LOGGER.debug((Object)("Added interface " + host));
            }
            config.getNetworkConfig().getInterfaces().setEnabled(true);
        } else if (!StringUtils.isBlank((String)netInterface)) {
            String ip = this.getIPv4AddressByInterface(netInterface).getHostAddress();
            config.getNetworkConfig().getInterfaces().addInterface(ip);
            LOGGER.debug((Object)("Added interface " + host));
            config.getNetworkConfig().getInterfaces().setEnabled(true);
        }
    }

    private void configureClusterDiscovery(Config config, Properties properties) {
        String discoveryType = properties.getProperty(this.discoveryTypeKey);
        LOGGER.debug((Object)("Hazelcast discovery type: " + discoveryType));
        if ("MULTICAST".equalsIgnoreCase(discoveryType)) {
            this.configureMulticastDiscovery(config, properties);
        } else {
            this.configureTcpIpDiscovery(config, properties);
        }
    }

    private void configureMulticastDiscovery(Config config, Properties properties) {
        String port;
        LOGGER.debug((Object)"Configuring multicast cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        String ip = properties.getProperty(this.multicastIpKey);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            LOGGER.debug((Object)("Cluster multicast group: " + ip));
        }
        if ((port = properties.getProperty(this.multicastPortKey)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            LOGGER.debug((Object)("Cluster multicast port: " + port));
        }
    }

    private void configureTcpIpDiscovery(Config config, Properties properties) {
        LOGGER.debug((Object)"Configuring TCP/IP cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        TcpIpConfig tcpip = config.getNetworkConfig().getJoin().getTcpIpConfig();
        String hosts = properties.getProperty(this.unicastHostsKey);
        if (hosts != null) {
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken();
                try {
                    InetAddress[] ias;
                    if (!StringUtils.isNotBlank((String)host)) continue;
                    LOGGER.debug((Object)("Adding host: " + host));
                    for (InetAddress iAddr : ias = InetAddress.getAllByName(host)) {
                        String addr = iAddr.getHostAddress();
                        LOGGER.debug((Object)("Adding " + host + " address: " + addr));
                        tcpip.addMember(addr);
                    }
                }
                catch (UnknownHostException ex) {
                    throw new RuntimeException("Unknown host: " + host);
                }
            }
        }
    }

    @Override
    public Config build() throws IOException {
        AdvancedProperties props = new AdvancedProperties();
        if (!props.loadFromFile(this.configFile)) {
            LOGGER.info((Object)("Could not load settings from file '" + this.configFile + "'. Will try loading from classpath."));
            if (!props.loadFromClassPath(this.configFile)) {
                LOGGER.info((Object)("Could not load settings from class path '" + this.configFile + "'. Will use default settings."));
                this.setDefaultProperties(this.configFile, props);
            }
        }
        return this.create(props);
    }

    void setDefaultProperties(String path, Properties props) {
        switch (path) {
            case "/opt/tandbergtv/cms/conf/neptune/cluster.properties": {
                props.put(this.discoveryTypeKey, "tcpip");
                props.put(this.unicastHostsKey, "app-nodes.service");
                props.put(this.clusterNameKey, "neptune");
                props.put(this.clusterPasswordKey, "neptune");
                props.put(this.portKey, "5950");
                props.put(this.autoIncrementKey, "false");
                break;
            }
            case "/opt/tandbergtv/cms/conf/neptune/oauthCluster.properties": {
                props.put(this.discoveryTypeKey, "tcpip");
                props.put(this.unicastHostsKey, "app-nodes.service");
                props.put(this.clusterNameKey, "oauth_neptune");
                props.put(this.clusterPasswordKey, "neptune");
                props.put(this.portKey, "5951");
                props.put(this.autoIncrementKey, "false");
                break;
            }
            case "/opt/tandbergtv/cms/conf/workflow/cluster.properties": {
                props.put(this.discoveryTypeKey, "tcpip");
                props.put(this.unicastHostsKey, "app-nodes.service");
                props.put(this.clusterNameKey, "workflow");
                props.put(this.clusterPasswordKey, "workflow");
                props.put(this.portKey, "5712");
                props.put(this.autoIncrementKey, "false");
                break;
            }
            case "/opt/tandbergtv/cms/conf/watchfolder/cluster.properties": {
                props.put(this.discoveryTypeKey, "tcpip");
                props.put(this.unicastHostsKey, "app-nodes.service");
                props.put(this.clusterNameKey, "watchfolder");
                props.put(this.clusterPasswordKey, "watchfolder");
                props.put(this.portKey, "5952");
                props.put(this.autoIncrementKey, "false");
                break;
            }
            case "/opt/tandbergtv/cms/conf/epgmgmt/hazelcast-epg.properties": {
                props.put(this.discoveryTypeKey, "tcpip");
                props.put(this.unicastHostsKey, "app-nodes.service");
                props.put(this.clusterNameKey, "epg");
                props.put(this.clusterPasswordKey, "epg");
                props.put(this.portKey, "6709");
                props.put(this.autoIncrementKey, "false");
                break;
            }
            default: {
                throw new RuntimeException("There are no default properties for " + path);
            }
        }
    }
}

