/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.service.impl;

import com.ericsson.cms.neptune.cluster.config.ConfigBuilder;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.impl.AbstractClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;

public class ClusterService
extends AbstractClusterService
implements IClusterService {
    private Config config;

    public ClusterService(String configFile) {
        super(configFile);
    }

    public ClusterService(Config config) {
        super(null);
        this.config = config;
    }

    @Override
    public Member getLocalMember() {
        return this.instance.getCluster().getLocalMember();
    }

    @Override
    public boolean isOwner(Object key) {
        return this.getLocalMember().equals(this.getPartition(key).getOwner());
    }

    @Override
    public Set<Member> members() {
        HashSet<Member> members = new HashSet<Member>(this.instance.getCluster().getMembers());
        members.remove(this.getLocalMember());
        return members;
    }

    @Override
    public boolean isLocalMember(InetSocketAddress address) {
        return this.getLocalMember().getSocketAddress().equals(address);
    }

    @Override
    public boolean isMaster() {
        return this.getMaster().equals(this.getLocalMember());
    }

    @Override
    protected HazelcastInstance createInstance() {
        try {
            if (this.config == null) {
                this.config = this.createConfig(this.configFile);
            }
            return this.doCreateInstance(this.config);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error when creating config from file: " + this.configFile, e);
        }
    }

    protected HazelcastInstance doCreateInstance(Config config) {
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    protected Config createConfig(String configFile) throws IOException {
        return new ConfigBuilder(configFile).build();
    }
}

