/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter.helper;

import com.ericsson.neptune.security.User;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class UsersCacheManager {
    private static Map<String, User> cachedUsers = new ConcurrentHashMap<String, User>();
    static ScheduledExecutorService executor;
    static Runnable runnable;
    static ScheduledFuture<?> future;
    static final String webserviceUrl = "https://app:8443/cms/services/users/self";
    private static final String USER_SERVICES = "services";
    private static UsersCacheManager instance;

    public static synchronized UsersCacheManager getInstance() {
        if (instance == null) {
            instance = new UsersCacheManager();
            instance.synchronize();
        }
        return instance;
    }

    public void synchronize() {
        executor = Executors.newScheduledThreadPool(1);
        runnable = new Runnable(){

            @Override
            public void run() {
                AuthProviderClient providerClient = new AuthProviderClient();
                try {
                    User userOld = null;
                    User userNew = providerClient.getSSLUser(UsersCacheManager.webserviceUrl);
                    if (cachedUsers.containsKey(UsersCacheManager.USER_SERVICES)) {
                        userOld = (User)cachedUsers.get(UsersCacheManager.USER_SERVICES);
                    }
                    if (!UsersCacheManager.this.isEqual(userNew, userOld)) {
                        cachedUsers.put(UsersCacheManager.USER_SERVICES, userNew);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        };
        future = executor.scheduleWithFixedDelay(runnable, 0L, 10L, TimeUnit.SECONDS);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        future.cancel(false);
        future = executor.scheduleWithFixedDelay(runnable, 0L, 300L, TimeUnit.SECONDS);
    }

    protected boolean isEqual(User userNew, User userOld) {
        if (userOld == null && userNew == null) {
            return true;
        }
        if (userOld == null) {
            return false;
        }
        if (userNew == null) {
            return true;
        }
        if (userNew.getId() != userOld.getId()) {
            return false;
        }
        if (userNew.getUserName().equals(userOld.getUserName())) {
            return false;
        }
        if (userNew.getDepartment().equals(userOld.getDepartment())) {
            return false;
        }
        if (userNew.getEmail().equals(userOld.getEmail())) {
            return false;
        }
        if (userNew.getEmployeeId().equals(userOld.getEmployeeId())) {
            return false;
        }
        if (userNew.getExtension().equals(userOld.getExtension())) {
            return false;
        }
        if (userNew.getFirstName().equals(userOld.getFirstName())) {
            return false;
        }
        if (userNew.getLastName().equals(userOld.getLastName())) {
            return false;
        }
        if (userNew.getLocation().equals(userOld.getLocation())) {
            return false;
        }
        if (userNew.getPhone().equals(userOld.getPhone())) {
            return false;
        }
        if (userNew.getRoleSets().size() != userOld.getRoleSets().size()) {
            return false;
        }
        for (int count = 0; count < userNew.getRoleSets().size(); ++count) {
            HashSet<String> roleSets = new HashSet<String>();
            roleSets.addAll(userNew.getRoleSets());
            roleSets.removeAll(userOld.getRoleSets());
            if (roleSets.size() == 0) continue;
            return false;
        }
        return true;
    }

    public User getUser(String userName) {
        User user = cachedUsers.get(userName);
        return user;
    }
}

