/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security;

import com.ericsson.neptune.security.authprovider.TokenInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class NeptunePrincipal {
    private String token;
    private Integer expiryLimit;
    private Date expiryDate = null;
    private String userName;
    private Set<String> roles;

    public NeptunePrincipal() {
    }

    public NeptunePrincipal(TokenInfo tokenInfo, String loginToken) {
        this.setToken(loginToken);
        this.setUserName(tokenInfo.getUser_name());
        this.setExpiryLimit(tokenInfo.getExpires_in());
    }

    public NeptunePrincipal(String username) {
        this.userName = username;
    }

    public boolean isExpired() {
        return this.expiryDate != null && Calendar.getInstance().getTime().after(this.expiryDate);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getExpiryLimit() {
        return this.expiryLimit;
    }

    public void setExpiryLimit(Integer expiryLimit) {
        this.expiryLimit = expiryLimit;
        if (expiryLimit != null && expiryLimit > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, expiryLimit);
            this.expiryDate = cal.getTime();
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String toString() {
        return "NeptunePrincipal [token=" + this.token + ", expiryLimit=" + this.expiryLimit + ", expiryDate=" + this.expiryDate + ", userName=" + this.userName + ", roles=" + this.roles + "]";
    }
}

