/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttributesUtil {
    private static Logger logger = Logger.getLogger(AttributesUtil.class);

    private AttributesUtil() {
    }

    public static String getSingleValue(Attributes attrs, String key) throws NamingException {
        if (attrs == null || StringUtils.isBlank((String)key)) {
            return null;
        }
        String attributeName = key.trim();
        Attribute attribute = attrs.get(attributeName);
        if (attribute == null) {
            return null;
        }
        if (attribute.size() == 1 || attribute.isOrdered()) {
            return (String)attribute.get();
        }
        ArrayList<String> values = new ArrayList<String>();
        NamingEnumeration<?> attributeValues = attribute.getAll();
        while (attributeValues.hasMore()) {
            Object attributeValue = attributeValues.next();
            if (attributeValue == null) continue;
            values.add(attributeValue.toString());
        }
        if (!values.isEmpty()) {
            Collections.sort(values, Collator.getInstance());
            return (String)values.get(0);
        }
        return null;
    }

    public static String getSingleValueQuiet(Attributes attrs, String key) {
        try {
            return AttributesUtil.getSingleValue(attrs, key);
        }
        catch (NamingException e) {
            logger.warn((Object)("cannot retrieve value of key[" + key + "] from " + attrs), (Throwable)e);
            return "";
        }
    }

    public static List<String> getMultipleValue(Attributes attrs, String key) throws NamingException {
        ArrayList<String> l = new ArrayList<String>(50);
        if (attrs == null || StringUtils.isBlank((String)key)) {
            return l;
        }
        String attributeName = key.trim();
        Attribute attribute = attrs.get(attributeName);
        if (attribute == null) {
            return l;
        }
        for (int i = 0; i < attribute.size(); ++i) {
            Object value = attribute.get(i);
            if (value == null) continue;
            l.add(value.toString());
        }
        return l;
    }

    public static List<String> getMultipleValueQuiet(Attributes attrs, String key) {
        try {
            return AttributesUtil.getMultipleValue(attrs, key);
        }
        catch (NamingException e) {
            logger.warn((Object)("cannot retrieve value of key[" + key + "] from " + attrs), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

