/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.audit;

import com.ericsson.neptune.security.audit.AbstractAuditor;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class RoleAuditor
extends AbstractAuditor<Role> {
    private static RoleAuditor instance = RoleAuditor.getInstance();

    protected RoleAuditor() {
    }

    public static RoleAuditor getInstance() {
        if (instance == null) {
            instance = new RoleAuditor();
        }
        return instance;
    }

    public String auditEntity(Role oldEntity, Role newEntity) {
        boolean isCreated;
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonNode = mapper.createObjectNode();
        ObjectNode changeNode = mapper.createObjectNode();
        boolean bl = isCreated = oldEntity == null;
        if (isCreated || this.hasStringValueChanged(newEntity.getName(), oldEntity.getName())) {
            changeNode.put("name", newEntity.getName());
        }
        if (isCreated || this.hasStringValueChanged(newEntity.getDescription(), oldEntity.getDescription())) {
            changeNode.put("description", newEntity.getDescription());
        }
        if (isCreated || newEntity.getPermissions().size() != oldEntity.getPermissions().size() || !newEntity.getPermissions().containsAll(oldEntity.getPermissions())) {
            ArrayNode permissionNode = mapper.createArrayNode();
            for (Permission permission : newEntity.getPermissions()) {
                permissionNode.add(permission.getModule().getName() + "_" + permission.getName());
            }
            changeNode.put("permissions", (JsonNode)permissionNode);
        }
        if (changeNode.getElements().hasNext()) {
            jsonNode.put(this.getEntityType(), (JsonNode)changeNode);
            return jsonNode.toString();
        }
        return null;
    }

    protected String getEntityType() {
        return "Role";
    }

    protected String getEntityName(Role entity) {
        long id = entity.getId() == null ? -1L : entity.getId();
        return entity.getName() + ":" + id;
    }
}

