/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad.model;

import com.ericsson.neptune.usermgmt.ad.AdPropertiesReader;
import com.ericsson.neptune.usermgmt.ad.exception.ADException;
import com.ericsson.neptune.usermgmt.ad.model.ADUser;
import com.ericsson.neptune.usermgmt.ad.util.AttributesUtil;
import com.ericsson.neptune.usermgmt.ad.util.NamingUtil;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserConverter {
    private static final String KEY_PREFIX = "ad.user";
    private static final String KEY_USERNAME = "ad.user.username";
    private static final String KEY_FIRSTNAME = "ad.user.firstname";
    private static final String KEY_LASTNAME = "ad.user.lastname";
    private static final String KEY_PHONE = "ad.user.phone";
    private static final String KEY_EMPLOYEE_ID = "ad.user.employeeid";
    private static final String KEY_EMAIL = "ad.user.email";
    private static final String KEY_DEPARTMENT = "ad.user.department";
    private static final String KEY_LOCATION = "ad.user.location";
    private static final String KEY_ROLES = "ad.user.roles";
    public static Logger logger = Logger.getLogger(UserConverter.class);
    private AdPropertiesReader adPropertiesReader;
    private IRoleManager roleManager;
    private Properties properties;
    private String[] adFields;

    @PostConstruct
    public void init() {
        this.properties = this.adPropertiesReader.getProperties();
        ArrayList<String> l = new ArrayList<String>(10);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String field;
            if (!((String)entry.getKey()).startsWith(KEY_PREFIX) || !StringUtils.isNotBlank((String)(field = (String)entry.getValue()))) continue;
            l.add(field);
        }
        this.adFields = l.toArray(new String[l.size()]);
    }

    public ADUser toAdUser(Attributes attrs) throws ADException {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        try {
            ADUser user = new ADUser();
            user.setUserName(AttributesUtil.getSingleValue(attrs, this.properties.getProperty(KEY_USERNAME)));
            user.setFirstName(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_FIRSTNAME)));
            user.setLastName(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_LASTNAME)));
            user.setPhone(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_PHONE)));
            user.setEmail(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_EMAIL)));
            user.setEmployeeId(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_EMPLOYEE_ID)));
            user.setDepartment(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_DEPARTMENT)));
            user.setLocation(AttributesUtil.getSingleValueQuiet(attrs, this.properties.getProperty(KEY_LOCATION)));
            user.setRoles(NamingUtil.getRoles(AttributesUtil.getMultipleValue(attrs, this.properties.getProperty(KEY_ROLES))));
            return user;
        }
        catch (Exception e) {
            throw new ADException("cannot convert user", e);
        }
    }

    public User toCMSUser(ADUser adUser) {
        if (adUser == null) {
            return null;
        }
        User u = new User();
        u.setActive(true);
        u.setDepartment(adUser.getDepartment());
        u.setEmail(adUser.getEmail());
        u.setEmployeeId(adUser.getEmployeeId());
        u.setExtension(adUser.getExtension());
        u.setFirstName(adUser.getFirstName());
        u.setLastName(adUser.getLastName());
        u.setLocation(adUser.getLocation());
        u.setPhone(adUser.getPhone());
        u.setUserName(adUser.getUserName());
        u.setRoles(this.getRolesByName(adUser.getRoles()));
        return u;
    }

    public Set<Role> getRolesByName(Set<String> roleNames) {
        if (roleNames == null || roleNames.isEmpty()) {
            return Collections.emptySet();
        }
        Map<String, Long> ids = this.roleManager.getRoleNameIdMap(roleNames);
        if (ids == null || ids.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Role> roles = new HashSet<Role>(ids.size());
        for (Map.Entry<String, Long> entry : ids.entrySet()) {
            Role r = new Role();
            r.setId(entry.getValue());
            r.setName(entry.getKey());
            roles.add(r);
        }
        return roles;
    }

    public void setAdPropertiesReader(AdPropertiesReader adPropertiesReader) {
        this.adPropertiesReader = adPropertiesReader;
    }

    public void setRoleManager(IRoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public String[] getAdFields() {
        return this.adFields;
    }
}

