/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.http;

import com.ericsson.neptune.http.NeptuneSSLSocketFactory;
import com.ericsson.neptune.security.util.SSLUtil;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HttpClientFactoryBean {
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final String HTTPS_HOST = "app";
    private static final int HTTPS_PORT = 8443;
    private static final String SCHEMA_HTTP = "http";
    private static final String SCHEMA_HTTPS = "https";
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 50;
    private static Logger logger = Logger.getLogger(HttpClientFactoryBean.class);
    private SSLUtil sslUtil;
    private String protocol = "https";
    private String host = "app";
    private int port = 8443;
    private String username;
    private String password;
    private int connectionPoolSize = 50;
    private int socketTimeout = 30000;
    private int connectionTimeout = 30000;

    public HttpClient getObject() throws Exception {
        HostConfiguration conf = new HostConfiguration();
        if (StringUtils.equals((String)this.protocol, (String)SCHEMA_HTTPS)) {
            Protocol https = new Protocol(SCHEMA_HTTPS, (ProtocolSocketFactory)new NeptuneSSLSocketFactory(this.sslUtil.getSslSocketFactory()), 8443);
            conf.setHost(this.host, this.port, https);
        } else if (StringUtils.equals((String)this.protocol, (String)SCHEMA_HTTP)) {
            conf.setHost(this.host, this.port, this.protocol);
        }
        MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams connParams = new HttpConnectionManagerParams();
        connParams.setMaxConnectionsPerHost(conf, this.connectionPoolSize);
        connParams.setMaxTotalConnections(this.connectionPoolSize);
        connParams.setConnectionTimeout(this.connectionTimeout);
        connParams.setSoTimeout(this.socketTimeout);
        connManager.setParams(connParams);
        logger.info((Object)("MaxConnectionsPerHost[" + this.connectionPoolSize + "], MaxTotalConnections[" + this.connectionPoolSize + "], ConnectionTimeout[" + this.connectionTimeout + "], SocketTimeout[" + this.socketTimeout + "]"));
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connManager);
        httpClient.setHostConfiguration(conf);
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            logger.info((Object)("setting BASIC authentication header for user[" + this.username + "]"));
            httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            httpClient.getState().setCredentials(new AuthScope(this.host, this.port), (Credentials)credentials);
        }
        return httpClient;
    }

    public void setSslUtil(SSLUtil sslUtil) {
        this.sslUtil = sslUtil;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

