/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NamingUtil {
    private static Logger logger = Logger.getLogger(NamingUtil.class);

    private NamingUtil() {
    }

    public static String getDC(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return "";
        }
        ArrayList<String> l = new ArrayList<String>(10);
        for (String dc : domain.split("\\.")) {
            l.add("DC=" + dc);
        }
        return StringUtils.join(l, (char)',');
    }

    public static String getUserDN(String pattern, String domain, Object ... args) {
        if (StringUtils.isBlank((String)pattern)) {
            return "";
        }
        return MessageFormat.format(pattern + "," + NamingUtil.getDC(domain), args);
    }

    public static String getSearchBaseDN(String base, String domain) {
        return StringUtils.isBlank((String)base) ? NamingUtil.getDC(domain) : base + "," + NamingUtil.getDC(domain);
    }

    public static Set<String> getRoles(List<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> roles = new HashSet<String>(values.size());
        for (String value : values) {
            String role = NamingUtil.getRole(value);
            if (!StringUtils.isNotBlank((String)role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static String getRole(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        String[] parts = value.split(",")[0].split("=");
        if (parts.length != 2) {
            logger.debug((Object)("invalid DN: " + value));
            return "";
        }
        return parts[1].trim();
    }

    public static String getSearchFilter(String filter, String username, String usernameKey) {
        String basic = NamingUtil.getBasicFilter(filter);
        String name = StringUtils.isBlank((String)username) ? "" : new StringBuilder(50).append('(').append(usernameKey).append('=').append(username).append(')').toString();
        return StringUtils.isBlank((String)basic) && StringUtils.isBlank((String)name) ? "" : "(&" + basic + name + ")";
    }

    public static String getSearchFilter(String filter, List<String> usernames, String usernameKey) {
        String basic = NamingUtil.getBasicFilter(filter);
        String names = NamingUtil.getUserFilter(usernames, usernameKey);
        return StringUtils.isBlank((String)basic) && StringUtils.isBlank((String)names) ? "" : "(&" + basic + names + ")";
    }

    public static String getUserFilter(List<String> usernames, String usernameKey) {
        if (usernames == null || usernames.isEmpty()) {
            logger.info((Object)"cannot get LDAP search filter, usernames are empty");
            return "";
        }
        if (StringUtils.isBlank((String)usernameKey)) {
            logger.info((Object)"cannot get LDAP search filter, username key is not provided, check property 'ad.user.username' in 'ActiveDirectory.properties'");
            return "";
        }
        StringBuilder builder = new StringBuilder(200);
        for (String username : usernames) {
            builder.append('(').append(usernameKey).append('=').append(username).append(')');
        }
        return usernames.size() == 1 ? builder.toString() : "(|" + builder.toString() + ")";
    }

    private static String getBasicFilter(String filter) {
        if (StringUtils.isBlank((String)filter)) {
            return "";
        }
        StringBuilder baseFilter = new StringBuilder(100);
        for (String f : filter.split(",")) {
            baseFilter.append('(').append(f.trim()).append(')');
        }
        return baseFilter.toString();
    }
}

