/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class FloatSettingValidator
extends AbstractSettingValidator {
    @Override
    public ValidationResult validate(SettingDefinition setting, String value) {
        ValidationResult result = new ValidationResult();
        if (value != null && !value.trim().isEmpty()) {
            try {
                Float.parseFloat(value);
            }
            catch (Exception e) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(setting.getDisplayName());
                result.fail().addMessage("{0} must be a valid float value.", "en", params);
            }
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

