package com.tandbergtv.neptune.ui.realm.client.settings.view;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiEnumeratedValue;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiEnumerationSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

public class EnumerationInputWidgetWrapper implements SettingsInputWidgetWrapper {
	
	protected ListBoxWidget<String> widget = null;
	private UiEnumerationSetting setting;
	private String initialValue;
	private String settingName;
	
	@Override
	public Widget createInputWidget() {
		widget = new ListBoxWidget<String>();
		widget.setName(setting.getName());
		// adds empty value.
		widget.addItem("", "");
		for (UiEnumeratedValue option : setting.getAllowedValue()) {
			widget.addItem(LocalizedSettingUtil.toLocalizedString(option.getDisplayName()), option.getValue());
		}
		if (initialValue != null && !initialValue.isEmpty()) {
			widget.setSelectedItem(initialValue);	
		}
		widget.setTitle(setting.getName());
		
		return widget;
	}
	
	@Override
	public String getValue() {
		return widget.getSelectedItem();
	}
	
	@Override
	public String getSettingName() {
		if (settingName == null) {
			return setting.getName();
		} else {
			return settingName;
		}
	}
	
	@Override
	public void setSettingName(String name) {
		this.settingName = name;
		if (widget != null) {
			widget.setTitle(name);
		}
	}

	@Override
	public SettingsInputWidgetWrapper newInstance() {
		return new EnumerationInputWidgetWrapper();
	}

	@Override
	public void setInitialValue(String initialValue) {
		this.initialValue = initialValue;
	}

	@Override
	public void setSettingDefinition(UiSettingDefinition setting) {
		this.setting = (UiEnumerationSetting) setting;
	}
	
	@Override
	public UiSettingDefinition getSettingDefinition() {
		return setting;
	}

}
