package com.tandbergtv.neptune.ui.realm.client.settings.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.RealmComponentPermissions;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingGroup;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingVisibility;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * 		Generic settings UI. Created based on metadata provided by the user.
 *
 * @author Francisco Bento da Silva Neto
 *
 */
public class BasicSettingsUI implements SettingsFormUI {

    private static final String STYLE_BORDER_NONE = "border-none-forced";

    private RealmConstants constants = GWT.create(RealmConstants.class);

    //private static final String HELP_ICON = "realm/images/help.png";
    private static final String HELP_ICON = "realm/images/information_black_16px.svg";
    private static final String CLOSE_ICON = "realm/images/X_black_16px.svg";

    private static final String RESTART_ICON = "realm/images/restart.png";
    private UiSettingGroup settingGroup;
    private Map<String, String> originalValues;
    private List<SettingsInputWidgetWrapper> inputWidgets;
    private SettingsLazyView view = null;

    private boolean restartRequired = false;

    public BasicSettingsUI(SettingsLazyView view) {
        this.view = view;
    }


    @Override
    public Widget createUI() {
        RoundedDisclosureContainer mainPanel = new RoundedDisclosureContainer(LocalizedSettingUtil.toLocalizedString(settingGroup.getDisplayName()));
        mainPanel.setTitle(settingGroup.getPath());

        VerticalPanel formPanel = new VerticalPanel();

        FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);


        //for (UiSettingDefinition setting : settingGroup.getSettings()) {
        for (final UiSettingDefinition setting : settingGroup.getSettings()) {


            // adds only the visible settings
            if ((setting.getVisibility() == null) || setting.getVisibility().equals(UiSettingVisibility.visible)) {
                HorizontalContainer fieldContainer = new HorizontalContainer();
                fieldContainer.addStyleName(STYLE_BORDER_NONE);

                LabelWidget label = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getDisplayName()));
                label.setTitle(setting.getName());

                ImageWidget helpIcon = new ImageWidget(HELP_ICON);

                helpIcon.setTitle(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));


                final LabelWidget helpWidget = new LabelWidget();
                helpWidget.setVisible(false);
                helpWidget.addStyleName("SettingsUiHelpText");

                helpIcon.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent event) {
                        //align this with GUI guideline.
                        // it should display/close the tip by click the tip icon.
                        boolean flag = helpWidget.isVisible();
                        helpWidget.setVisible(!flag);
                        helpWidget.setText(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
                    }
                });

                helpIcon.addStyleName("SettingsUiHelpIcon");


                //				LabelWidget helpWidget = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
                //				helpWidget.addStyleName("SettingsUiHelpText");


                /**Code changes ends by Shrikant Roy*/

                boolean isRequired = setting.getRequired();

                SettingsInputWidgetWrapper widgetWrapper = SettingsWidgetFactory.getWidgetFor(setting, originalValues.get(setting.getName()));

                fieldContainer.add(widgetWrapper.createInputWidget());


                if (setting.isRestartRequired()) {
                    ImageWidget restartIcon = new ImageWidget(RESTART_ICON);
                    restartIcon.setTitle(constants.settingRequiresRestart());
                    restartIcon.addStyleName("SettingsUiHelpIcon");
                    fieldContainer.add(restartIcon);
                }
                fieldContainer.add(helpIcon);
                fieldContainer.add(helpWidget);
                formContainer.addRow(label, fieldContainer.asWidget(), isRequired);
                inputWidgets.add(widgetWrapper);
            }
        }
        formContainer.addButton(getSaveButton());
        formContainer.addButton(getCancelButton());
        formContainer.AddButtonPanelStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
        formPanel.add(formContainer);

        mainPanel.add(formPanel);
        mainPanel.setOpen(true);
        mainPanel.setWidth("100%");
        return mainPanel;
    }

    private ButtonWidget getSaveButton(){
        ButtonWidget btnSave = new ButtonWidget(constants.saveButton());
        btnSave.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
        btnSave.addStyleName(StyleNames.STYLE_EB_BTN);
        btnSave.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
        btnSave.addStyleName(StyleNames.STYLE_SAVE_BUTTON_ICON);

        if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY)) {
            btnSave.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    view.clearErrors();//clearErrors();
                    view.saveSettings();
                }
            });
        }
        btnSave.setVisible(ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY));


        return btnSave;
    }

    private ButtonWidget getCancelButton(){
        ButtonWidget btnCancel = new ButtonWidget(constants.cancelButton());
        btnCancel.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
        btnCancel.addStyleName(StyleNames.STYLE_EB_BTN);

        btnCancel.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                view.clearErrors();
                view.settingsTree.setSelectedItem(null);
                view.clearEditorForm();
                originalValues = null;
            }
        });
        btnCancel.setVisible(ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY));

        return btnCancel;

    }

    @Override
    public void setSettingGroup(UiSettingGroup settingGroup) {
        this.settingGroup = settingGroup;
        this.inputWidgets = new ArrayList<SettingsInputWidgetWrapper>(settingGroup.getSettings().size());
    }

    @Override
    public UiSettingGroup getSettingGroup() {
        return settingGroup;
    }

    @Override
    public void setSettingsValues(Map<String, String> settingsValues) {
        this.originalValues = settingsValues;
    }

    @Override
    public void resetOriginalValues() {
        this.originalValues = this.getWidgetsKeyValues();
    }

    @Override
    public Map<String, String> applyChanges() {
        Map<String, String> newValues = new HashMap<String, String>(originalValues.size());
        for (SettingsInputWidgetWrapper input : inputWidgets) {
            if (input.getSettingDefinition().isRestartRequired()) {
                if (!input.getValue().equals(originalValues.get(input.getSettingName()))) {
                    restartRequired = true;
                }

            }
            newValues.put(input.getSettingName(), input.getValue());
        }

        return newValues;
    }

    @Override
    public boolean haveSettingsChanged() {

        for (SettingsInputWidgetWrapper input : inputWidgets) {
            if (originalValues != null) {
                if (!input.getValue().equals(
                        originalValues.get(input.getSettingName()))) {
                    return true;
                }
            }
        }
        return false;

    }

    @Override
    public boolean requiresRestart() {
        return restartRequired;
    }

    public List<SettingsInputWidgetWrapper> getInputWidgets() {
        return this.inputWidgets;
    }

    private Map<String, String> getWidgetsKeyValues() {

        Map<String, String> widgetsKeyValues = new HashMap<String, String>();
        for (SettingsInputWidgetWrapper input : inputWidgets) {
            widgetsKeyValues.put(input.getSettingName(), input.getValue());
        }

        return widgetsKeyValues;
    }

}
