package com.tandbergtv.neptune.widgettoolkit.client.security;


/**
 * Gives access to the user name and roles (permissions) of the currently logged in user.
 * 
 * @author trybak
 */
public interface NeptuneSecurity {

	/**
	 * Get the user name of the currently logged in user
	 * 
	 * @return The user name
	 */
	String getUsername();

	/**
	 * Checks if the user has a specific role
	 * 
	 * @param role The role name
	 * @return true if the user has the role, false otherwise
	 */
	boolean isUserInRole(String role);
}
