/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link HTML} widget.
 * 
 * @see com.google.gwt.user.client.ui.HTML
 * @author Vijay Silva
 */
public class HTMLWidget extends HTML implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.HTML#HTML()
	 */
	public HTMLWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.HTML#HTML(String)
	 */
	public HTMLWidget(String html) {
		super(html);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.HTML#HTML(String, boolean)
	 */
	public HTMLWidget(String html, boolean wordWrap) {
		super(html, wordWrap);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.HTML#HTML(Element)
	 */
	protected HTMLWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.HTML#wrap(Element)
	 */
	public static HTMLWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		HTMLWidget widget = new HTMLWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
