/*
 * Created on Feb 10, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.GwtEvent;

/**
 * The Refresh Event fired for refreshing the contents of a widget
 * 
 * @author Vijay Silva
 */
public class RefreshEvent extends GwtEvent<RefreshHandler> {

	/* The Handler type */
	private static Type<RefreshHandler> TYPE;

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<RefreshHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<RefreshHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<RefreshHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(RefreshHandler handler) {
		handler.onRefresh(this);
	}
}
