/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;

public class InjectionUtil {
    private static final String JNDI_PREFIX = "java:global/";

    public static <E> E injectInstance(String jndiName, Class<E> clazz) {
        return InjectionUtil.injectInstance(jndiName, clazz, null);
    }

    public static <E> E injectInstance(String jndiName, Class<E> clazz, InitialContext initialContext) {
        try {
            if (null == initialContext) {
                initialContext = new InitialContext();
            }
            return clazz.cast(initialContext.lookup(JNDI_PREFIX + jndiName));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <E> E injectInstance(Class<? extends E> implementation, Class<E> clazz) {
        String jndiName = "cms/" + implementation.getSimpleName() + "/local";
        return InjectionUtil.injectInstance(jndiName, clazz);
    }

    public static <T> T injectInstance(String jndiName) {
        try {
            return InitialContext.doLookup(JNDI_PREFIX + jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

