package com.tandbergtv.neptune.ui.realm.client.settings.service;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Service that provides access to Settings configuration.
 *
 * @author Francisco B. S. Neto
 */
@RemoteServiceRelativePath("service/realm/ISettingsUIService")
public interface ISettingsUIService extends RemoteService {

    /**
     * 		Returns all settings definitions.
     *
     * @return
     * @throws NeptuneException
     */
    List<UiSettingGroup> getAllSettingDefinitions() throws NeptuneException;

    /**
     * 		Filters the settings definitions.
     *
     * @return
     * @throws NeptuneException
     */
    List<UiSettingGroup> findSettingDefinitions(String filter) throws NeptuneException;

    /**
     * 		Gets the values specified for the settings.
     *
     * @param settingsPath
     * @return
     * @throws NeptuneException
     */
    Map<String, String> getSettingsValues(String settingsPath) throws NeptuneException;

    /**
     * Get the neptune settings with the given path and the current access token in one single call.
     * 
     * @param settingsPath
     * @return
     * @throws NeptuneException
     */
    UiTokenAndSettings getTokenAndSettings(String settingsPath) throws NeptuneException;

    /**
     * 		Saves the settings.
     * @param group
     * @param values
     * @throws NeptuneException
     */
    void saveSettings(UiSettingGroup group, Map<String, String> values) throws NeptuneException;

    /**
     * 		Return the validation errors for the specified group.
     *
     * @param group
     * @return
     * @throws NeptuneException
     */
    List<String> validateSettingGroup(String group) throws NeptuneException;

    /**
     * 		Returns true in case exists any group with inconsistent settings.
     *
     * @return
     */
    Boolean hasInconsistentGroups() throws NeptuneException;

}
