/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CheckBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link CheckBox} widget.
 * 
 * @see com.google.gwt.user.client.ui.CheckBox
 * @author Vijay Silva
 */
public class CheckBoxWidget extends CheckBox implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.CheckBox#CheckBox()
	 */
	public CheckBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.CheckBox#CheckBox(String)
	 */
	public CheckBoxWidget(String label) {
		super(label);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.CheckBox#CheckBox(String, boolean)
	 */
	public CheckBoxWidget(String label, boolean asHTML) {
		super(label, asHTML);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.CheckBox#CheckBox(Element)
	 */
	protected CheckBoxWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
