/*
 * Created on May 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter;

/**
 * Converts a value from integer to string and vice versa
 * 
 * @author Vijay Silva
 */
public class IntegerConverter implements IValueConverter<Long> {

	/**
	 * Constructor
	 */
	public IntegerConverter() {
	}

	@Override
	public String getStringValue(Long typedValue) {
		return (typedValue == null) ? null : typedValue.toString();
	}

	@Override
	public Long getTypedValue(String value) throws ValueFormatException {
		Long result = null;

		try {
			if (value != null && value.trim().length() > 0) {
				result = new Long(value.trim());
			}
		} catch (NumberFormatException nfe) {
			throw new ValueFormatException(value + " is not a valid integer.");
		}

		return result;
	}
}
