/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.licensing.LicenseUtil;
import com.tandbergtv.neptune.licensing.elim.CapacityKey;
import com.tandbergtv.neptune.licensing.elim.FeatureKey;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Local(value={ILicenseManager.class})
@Stateless
public class LicenseManager
implements ILicenseManager {
    private static final String NEPTUNE_DIR = "neptune";
    private static final Logger logger = Logger.getLogger(LicenseManager.class);
    private static final String ELIM_LICENSE_FILE_NAME = "license.xml";
    private static final String EMPTY_STRING = "";
    private static final String KEY_CMS_BASE = "FAT1022759";
    private static final String KEY_INGEST_THRUPUT = "FAT1021117";
    private static final String KEY_DIST_THRUPUT = "FAT1021118";
    private static final String KEY_MASTER_TITLES = "FAT1021119";
    private static final String KEY_SITE_TITLES = "FAT1021120";
    private static final String KEY_TENANTS = "FAT1021121";
    private static final String KEY_PREPACK = "FAT1021122";
    private static final String KEY_CMSR_ONLY = "FAT1023107";
    private static final String KEY_CMSR_CHANNELS = "FAT1023149";
    private static final Properties defaults;
    private static Properties licProps;
    private static long lastModTime;
    private static long lastCheck;
    private static Map<String, String> propertyDictionary;
    private static Map<String, Long> propertyBlockSize;

    public Properties getProperties() throws InvalidLicenseException {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File file = configReaderService.getFile(NEPTUNE_DIR, ELIM_LICENSE_FILE_NAME);
        if (file.exists()) {
            logger.debug((Object)("ELIM license file present: " + file.getPath()));
            return this.getElimLicProperties(file);
        }
        throw new InvalidLicenseException("ELIM license file does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getElimLicProperties(File file) throws InvalidLicenseException {
        if (!file.exists()) {
            logger.error((Object)("[Configuration Error] license.xml " + file.getAbsolutePath() + " license file not found"));
            throw new InvalidLicenseException("License file not found");
        }
        if (System.currentTimeMillis() - lastCheck > 60000L) {
            if (file.lastModified() > lastModTime) {
                LicenseManager.updateProperties(file);
            } else {
                lastCheck = System.currentTimeMillis();
            }
        }
        Properties properties = licProps;
        synchronized (properties) {
            return (Properties)licProps.clone();
        }
    }

    public Properties getProperties(File parentFolder) throws InvalidLicenseException {
        File neptuneDir = new File(parentFolder, NEPTUNE_DIR);
        File licenseFile = new File(neptuneDir, ELIM_LICENSE_FILE_NAME);
        return this.getElimLicProperties(licenseFile);
    }

    public String getProperty(String key) throws InvalidLicenseException {
        return this.getProperties().getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void updateProperties(File file) throws InvalidLicenseException {
        if (System.currentTimeMillis() - lastCheck > 60000L && file.lastModified() > lastModTime) {
            logger.debug((Object)("Found new ELIM license file " + file.getPath()));
            LicenseUtil licenseUtil = null;
            try {
                licenseUtil = new LicenseUtil(file);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
            }
            if (!licenseUtil.validateLicense()) {
                throw new InvalidLicenseException("License file not valid");
            }
            Properties licPropsUpdate = new Properties();
            licPropsUpdate.putAll((Map<?, ?>)defaults);
            GregorianCalendar c = new GregorianCalendar();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            List<FeatureKey> featureKeys = licenseUtil.getFeatureKeys();
            for (FeatureKey featureKey : featureKeys) {
                if (featureKey.getStartDate().before(c.getTime()) && (featureKey.getNoStop() || featureKey.getStopDate().after(c.getTime()))) {
                    LicenseManager.logValidFeatureKey(featureKey);
                } else {
                    LicenseManager.logInvalidFeatureKey(featureKey);
                }
                String propKey = propertyDictionary.get(LicenseManager.normalizeKey(featureKey.getId()));
                if (propKey == null) {
                    propKey = featureKey.getId();
                }
                licPropsUpdate.setProperty(propKey, "true");
            }
            List<CapacityKey> capacityKeys = licenseUtil.getCapacityKeys();
            for (CapacityKey key : capacityKeys) {
                String id = LicenseManager.normalizeKey(key.getId());
                String propKey = propertyDictionary.get(id);
                if (propKey == null) {
                    propKey = id;
                }
                if (key.getStartDate().before(c.getTime()) && (key.getNoStop() || key.getStopDate().after(c.getTime())) && !propKey.equals("IsRCSOnly")) {
                    LicenseManager.logValidCapacityKey(key);
                } else if (propKey.equals("IsRCSOnly")) {
                    FeatureKey rcsOnlyFeatureKey = new FeatureKey();
                    rcsOnlyFeatureKey.setId(id);
                    rcsOnlyFeatureKey.setDesc(key.getDesc());
                    LicenseManager.logValidFeatureKey(rcsOnlyFeatureKey);
                } else {
                    LicenseManager.logInvalidCapacityKey(key);
                }
                long capValue = key.getCapacity();
                Long blockSize = propertyBlockSize.get(id);
                if (blockSize != null) {
                    capValue *= blockSize.longValue();
                }
                if (!propKey.equals("IsRCSOnly")) {
                    licPropsUpdate.setProperty(propKey, String.valueOf(capValue));
                    continue;
                }
                licPropsUpdate.setProperty(propKey, "true");
            }
            StringWriter stringWriter = new StringWriter();
            licPropsUpdate.list(new PrintWriter(stringWriter));
            logger.debug((Object)("ELIM License " + stringWriter.getBuffer().toString()));
            Properties properties = licProps;
            synchronized (properties) {
                licProps = licPropsUpdate;
            }
            lastModTime = file.lastModified();
            lastCheck = System.currentTimeMillis();
            logger.info((Object)("New ELIM license file " + file.getPath() + " ingest completed"));
        }
    }

    private static String normalizeKey(String id) {
        if (id == null) {
            return null;
        }
        int idx = id.indexOf(47);
        return idx > -1 ? id.substring(0, idx) : id;
    }

    private static Properties defaults() {
        Properties result = new Properties();
        result.put("SiteID", EMPTY_STRING);
        result.put("expirationDate", EMPTY_STRING);
        result.put("templates", EMPTY_STRING);
        result.put("resourceTypes", EMPTY_STRING);
        result.put("systemResources", EMPTY_STRING);
        result.put("humanResources", EMPTY_STRING);
        result.put("seatLicense", EMPTY_STRING);
        result.put("PMMLicense", "true");
        result.put("EditImageLicense", "true");
        result.put("VideoPreviewLicense", "true");
        result.put("Sites.DistributionSite.MaxCount", EMPTY_STRING);
        result.put("Sites.TrackingSite.MaxCount", EMPTY_STRING);
        result.put("ProviderPortalLicense", "true");
        result.put("MetadataFormats.MaxCount", EMPTY_STRING);
        result.put("SchedulerLicense", "true");
        result.put("ContractMgrLicense", "true");
        result.put("CategoryManagerLicense", "true");
        result.put("TSTVLicense", "true");
        result.put("IsRCSOnly", "false");
        result.put("RCS.MaxRms", EMPTY_STRING);
        result.put("cmsr.channels", "0");
        result.put("MetadataEnhancementLicense", "true");
        result.put("EPGManagerLicense", "true");
        result.put("HALicense", "true");
        result.put("DistOnly", "false");
        return result;
    }

    private static void logValidFeatureKey(FeatureKey key) {
        logger.info((Object)("License Feature key [" + key.getId() + "(" + key.getDesc() + ")] is valid"));
        logger.info((Object)("Adding Feature key " + key.getId() + ", value = true"));
    }

    private static void logValidCapacityKey(CapacityKey key) {
        logger.info((Object)("License Capacity key [" + key.getId() + "(" + key.getDesc() + ")] is valid"));
        logger.info((Object)("Adding capacity key " + key.getId() + ", value = " + String.valueOf(key.getCapacity())));
    }

    private static void logInvalidFeatureKey(FeatureKey key) {
        logger.warn((Object)("License Feature key [" + key.getId() + "(" + key.getDesc() + ")] is NOT valid"));
        logger.info((Object)("Adding Feature key " + key.getId() + ", value = true"));
    }

    private static void logInvalidCapacityKey(CapacityKey key) {
        logger.warn((Object)("License Capacity key [" + key.getId() + "(" + key.getDesc() + ")] is NOT valid"));
        logger.info((Object)("Adding capacity key " + key.getId() + ", value = " + String.valueOf(key.getCapacity())));
    }

    static {
        licProps = defaults = LicenseManager.defaults();
        lastModTime = 0L;
        lastCheck = 0L;
        propertyDictionary = new HashMap<String, String>();
        propertyDictionary.put("FAV901339/3A", "CMS");
        propertyDictionary.put(KEY_CMS_BASE, "Content");
        propertyDictionary.put(KEY_INGEST_THRUPUT, "ingest.thruput");
        propertyDictionary.put(KEY_DIST_THRUPUT, "dist.thruput");
        propertyDictionary.put(KEY_MASTER_TITLES, "master.titles");
        propertyDictionary.put(KEY_SITE_TITLES, "sites.titles");
        propertyDictionary.put(KEY_TENANTS, "wholesale");
        propertyDictionary.put(KEY_PREPACK, "prepak");
        propertyDictionary.put(KEY_CMSR_ONLY, "IsRCSOnly");
        propertyDictionary.put(KEY_CMSR_CHANNELS, "cmsr.channels");
        propertyBlockSize = new HashMap<String, Long>();
        propertyBlockSize.put(KEY_MASTER_TITLES, 1000L);
        propertyBlockSize.put(KEY_SITE_TITLES, 2000L);
        propertyBlockSize.put(KEY_INGEST_THRUPUT, 1000L);
        propertyBlockSize.put(KEY_DIST_THRUPUT, 1000L);
    }
}

