/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.tandbergtv.neptune.alerts.rest.client.RestClient;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

@MessageDriven(name="AlertCmdHandlerMDBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/AlertCmdQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class AlertCmdMDBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(AlertCmdMDBean.class);
    private static final String ALERT_TIME_INTERVAL_SETTING = "com.ericsson.cms.neptune.uialerts.timeinterval";
    private static final String READ_TIMEOUT_SETTING = "read_timeout";
    @EJB
    private ISettingsService settingsService;
    private int connTimeout = 4000;
    private int readTimeout = 10000;
    @Resource(mappedName="java:/ConnectionFactory")
    private QueueConnectionFactory queueFactory;
    private RestClient restClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        long lStartTime = System.nanoTime();
        QueueSession replySession = null;
        QueueConnection queueConnection = null;
        try {
            Destination returnDestination = msg.getJMSReplyTo();
            if (returnDestination == null) {
                return;
            }
            String res = this.getRestClient().getAlerts(msg.getStringProperty("url"));
            queueConnection = this.queueFactory.createQueueConnection();
            replySession = queueConnection.createQueueSession(false, 1);
            MessageProducer messageProducer = replySession.createProducer(returnDestination);
            messageProducer.setDeliveryMode(1);
            TextMessage returnMessage = replySession.createTextMessage(res);
            returnMessage.setJMSCorrelationID(msg.getJMSMessageID());
            messageProducer.send((Message)returnMessage);
        }
        catch (Exception e) {
            logger.error((Object)"error when getting alerts", (Throwable)e);
        }
        finally {
            try {
                if (replySession != null) {
                    replySession.close();
                }
            }
            catch (JMSException e) {
                logger.warn((Object)("Failed to close the JMS session: " + e.getLocalizedMessage()));
            }
            try {
                if (queueConnection != null) {
                    queueConnection.close();
                }
            }
            catch (JMSException e) {
                logger.warn((Object)("cannot close JMS queue connection: " + e.getLocalizedMessage()));
            }
            long lEndTime = System.nanoTime();
            long difference = lEndTime - lStartTime;
            logger.info((Object)("Elapsed milliseconds in onMessage : " + difference / 1000000L));
        }
    }

    @PostConstruct
    public void loadReadTimeoutSetting() {
        try {
            this.readTimeout = Integer.parseInt((String)this.settingsService.getProperties(ALERT_TIME_INTERVAL_SETTING).get(READ_TIMEOUT_SETTING));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to parse setting com.ericsson.cms.neptune.uialerts.timeinterval, read_timeout. Using default value " + this.readTimeout), (Throwable)e);
        }
    }

    private RestClient getRestClient() {
        if (this.restClient == null) {
            this.restClient = new RestClient(this.readTimeout, this.connTimeout);
        }
        return this.restClient;
    }
}

