/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.cache;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.IClusterConfigurationService;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.realm.persist.Setting;
import com.tandbergtv.neptune.realm.persist.SettingGroup;
import com.tandbergtv.neptune.settings.cache.SettingsChangeHazelcastMessage;
import com.tandbergtv.neptune.settings.cache.SettingsMessageListener;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class SettingsCache {
    private static final Logger logger = Logger.getLogger(SettingsCache.class);
    private static String DISTRIBUTED_SETTINGS_UPDATE_TOPIC_NAME = "SETTINGS_UPDATE_TOPIC";
    private static SettingsCache instance;
    private Map<String, Map<String, String>> settingsGroupCache = new ConcurrentHashMap<String, Map<String, String>>();
    private ITopic<SettingsChangeHazelcastMessage> settingsUpdateTopic;
    private SettingsMessageListener settingsMsgListener;
    private IClusterService clusterService;
    private static Lock lock;

    private SettingsCache() {
        logger.debug((Object)"SettingsCache initializing");
        this.settingsUpdateTopic = this.getClusterService().getInstance().getTopic(DISTRIBUTED_SETTINGS_UPDATE_TOPIC_NAME);
        this.settingsMsgListener = new SettingsMessageListener(this.getClusterService(), this);
        this.settingsUpdateTopic.addMessageListener((MessageListener)this.settingsMsgListener);
    }

    public static SettingsCache getInstance() {
        if (instance != null) {
            return instance;
        }
        lock.lock();
        try {
            if (instance == null) {
                instance = new SettingsCache();
            }
            SettingsCache settingsCache = instance;
            return settingsCache;
        }
        finally {
            lock.unlock();
        }
    }

    public void cacheGroup(SettingGroup group) {
        if (group == null) {
            return;
        }
        String groupPath = group.getPath();
        if (this.settingsGroupCache.get(groupPath) == null) {
            this.settingsGroupCache.put(groupPath, new ConcurrentHashMap());
        }
    }

    public void cacheSetting(Setting setting) {
        this.cache(setting);
    }

    public void removeSettingCache(Setting setting) {
        if (setting == null) {
            return;
        }
        logger.info((Object)("Removing settings from cache " + setting.getName()));
        String groupPath = setting.getGroup().getPath();
        Map<String, String> groupSettings = this.settingsGroupCache.get(groupPath);
        if (groupSettings != null) {
            groupSettings.remove(setting.getName());
        }
    }

    public Map<String, String> readSettingsFromCache(String settingsPath) {
        Map<String, String> cachedSettigns = this.settingsGroupCache.get(settingsPath);
        int size = cachedSettigns == null ? 0 : cachedSettigns.size();
        HashMap<String, String> retVal = new HashMap<String, String>(size);
        if (cachedSettigns != null) {
            retVal.putAll(cachedSettigns);
        }
        return retVal;
    }

    public void publishSettingsUpdate(String settingsPath) {
        logger.debug((Object)("Publish Settings Path was called for " + settingsPath));
        SettingsChangeHazelcastMessage msg = new SettingsChangeHazelcastMessage();
        msg.setSender(this.clusterService.getLocalMember().getSocketAddress());
        msg.setGroupPath(settingsPath);
        this.settingsUpdateTopic.publish((Object)msg);
    }

    private void cache(Setting setting) {
        if (setting == null) {
            return;
        }
        String groupPath = setting.getGroup().getPath();
        logger.debug((Object)("Caching Settings for " + groupPath + "::" + setting.getName()));
        Map<String, String> groupSettings = this.settingsGroupCache.get(groupPath);
        if (groupSettings == null) {
            groupSettings = new ConcurrentHashMap<String, String>();
            this.settingsGroupCache.put(groupPath, groupSettings);
        }
        groupSettings.put(setting.getName(), setting.getValue() == null ? "" : setting.getValue());
    }

    public void updateGroup(String groupPath) {
        logger.debug((Object)("refresh setting cache for path[" + groupPath + "]"));
        Collection<Setting> settings = this.findSettingsByGroup(groupPath);
        ConcurrentHashMap<String, String> settingsMap = new ConcurrentHashMap<String, String>();
        if (settings != null) {
            for (Setting s : settings) {
                settingsMap.put(s.getName(), s.getValue() == null ? "" : s.getValue());
            }
        }
        this.settingsGroupCache.put(groupPath, settingsMap);
    }

    private Collection<Setting> findSettingsByGroup(String settingsPath) {
        ISettingsService settingsService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);
        Collection settings = settingsService.findSettingsByGroup(settingsPath);
        return settings;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = Cluster.getService((String)IClusterConfigurationService.CLUSTER_CONFIG_PATH);
        }
        return this.clusterService;
    }

    static {
        lock = new ReentrantLock();
    }
}

