/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import com.ericsson.cms.neptune.cluster.config.AbstractConfigBuilder;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.TcpIpConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfigBuilder
extends AbstractConfigBuilder<Config> {
    private static final Logger LOGGER = Logger.getLogger(ConfigBuilder.class);

    public ConfigBuilder(String configFile) {
        super(configFile);
    }

    private Config create(Properties properties) throws IOException {
        System.setProperty("hazelcast.logging.type", "log4j");
        String xmlPath = properties.getProperty("xml.config.path");
        if (xmlPath != null) {
            FileSystemXmlConfig cfg = new FileSystemXmlConfig(xmlPath);
            return cfg;
        }
        ClasspathXmlConfig config = null;
        try {
            config = new ClasspathXmlConfig(ConfigBuilder.class.getClassLoader(), "com/ericsson/cms/neptune/cluster/config/hazelcast-datastructure.xml");
        }
        catch (Exception e) {
            LOGGER.warn((Object)("cannot read internal data structure configuration, use default, error: " + e));
            config = new Config();
        }
        this.configureClusterDiscovery((Config)config, properties);
        this.configurePort(properties, (Config)config);
        this.configureClusterHost((Config)config, properties);
        this.configureClusterName((Config)config, properties);
        this.configureInitialWait((Config)config, properties);
        return config;
    }

    private void configurePort(Properties properties, Config config) {
        String autoIncrementStr;
        int port = this.defaultPort;
        try {
            port = Integer.parseInt(properties.getProperty(this.portKey));
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)("invalid port number, check configuration in [" + this.configFile + "], try to use default[" + this.defaultPort + "], error is: " + e.getLocalizedMessage()));
        }
        if (port > -1) {
            config.getNetworkConfig().setPort(port);
        }
        if (StringUtils.isNotBlank((String)(autoIncrementStr = properties.getProperty(this.autoIncrementKey)))) {
            this.isPortAutoIncrement = Boolean.parseBoolean(autoIncrementStr);
        }
        config.getNetworkConfig().setPortAutoIncrement(this.isPortAutoIncrement);
    }

    private void configureInitialWait(Config config, Properties properties) throws IOException {
        String wait = properties.getProperty(this.initialWaitKey);
        if (StringUtils.isNotBlank((String)wait)) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private void configureClusterName(Config config, Properties properties) throws IOException {
        String password;
        String name = properties.getProperty(this.clusterNameKey);
        if (name != null) {
            LOGGER.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(this.clusterPasswordKey)) != null) {
            config.getGroupConfig().setPassword(password);
        }
    }

    private void configureClusterHost(Config config, Properties properties) throws IOException {
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(this.hostKey);
        if (StringUtils.isBlank((String)host)) {
            LOGGER.warn((Object)"Host IP address not provided");
            String netInterface = properties.getProperty(this.interfaceKey);
            String hostip = "";
            if (StringUtils.isNotBlank((String)netInterface)) {
                hostip = this.getAddressByInterface(netInterface).getHostAddress();
            } else {
                hostip = this.getAddress().getHostAddress();
                LOGGER.warn((Object)"Setting default host");
            }
            config.getNetworkConfig().getInterfaces().addInterface(hostip);
            LOGGER.debug((Object)("Cluster host " + hostip));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(host, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken().trim();
                if (!StringUtils.isNotBlank((String)token)) continue;
                config.getNetworkConfig().getInterfaces().addInterface(token);
            }
            LOGGER.debug((Object)("Cluster host " + host));
        }
        config.getNetworkConfig().getInterfaces().setEnabled(true);
    }

    private void configureClusterDiscovery(Config config, Properties properties) {
        String discoveryType = properties.getProperty(this.discoveryTypeKey);
        LOGGER.debug((Object)("Hazelcast discovery type: " + discoveryType));
        if ("tcpip".equalsIgnoreCase(discoveryType)) {
            this.configureTcpIpDiscovery(config, properties);
        } else {
            this.configureMulticastDiscovery(config, properties);
        }
    }

    private void configureMulticastDiscovery(Config config, Properties properties) {
        String port;
        LOGGER.debug((Object)"Configuring multicast cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        String ip = properties.getProperty(this.multicastIpKey);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            LOGGER.debug((Object)("Cluster multicast group: " + ip));
        }
        if ((port = properties.getProperty(this.multicastPortKey)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            LOGGER.debug((Object)("Cluster multicast port: " + port));
        }
    }

    private void configureTcpIpDiscovery(Config config, Properties properties) {
        LOGGER.debug((Object)"Configuring TCP/IP cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        TcpIpConfig tcpip = config.getNetworkConfig().getJoin().getTcpIpConfig();
        String hosts = properties.getProperty(this.unicastHostsKey);
        if (hosts != null) {
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken();
                try {
                    if (!StringUtils.isNotBlank((String)host)) continue;
                    LOGGER.debug((Object)("Adding host: " + host));
                    tcpip.addMember(host);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("Could not add host: " + host), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public Config build() throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(this.configFile));
        return this.create(props);
    }
}

