/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import com.ericsson.cms.neptune.cluster.config.AbstractConfigBuilder;
import com.hazelcast.client.config.ClientConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class ClientConfigBuilder
extends AbstractConfigBuilder<ClientConfig> {
    private static final Logger LOGGER = Logger.getLogger(ClientConfigBuilder.class);
    private String ip;

    public ClientConfigBuilder(String configFile) {
        super(configFile);
    }

    public ClientConfigBuilder ip(String ip) {
        this.ip = ip;
        return this;
    }

    private ClientConfig create(Properties properties) throws IOException {
        System.setProperty("hazelcast.logging.type", "log4j");
        ClientConfig config = new ClientConfig();
        this.configureClusterHost(config, properties);
        this.configureClusterName(config, properties);
        this.configureInitialWait(config, properties);
        return config;
    }

    private void configureInitialWait(ClientConfig config, Properties properties) {
        String wait = properties.getProperty(this.initialWaitKey);
        if (StringUtils.isNotBlank((String)wait)) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private void configureClusterName(ClientConfig config, Properties properties) {
        String name = properties.getProperty(this.clusterNameKey);
        Validate.notEmpty((String)name, (String)(this.clusterNameKey + " cannot be empty"));
        LOGGER.debug((Object)("Cluster name " + name));
        config.getGroupConfig().setName(name);
        String password = properties.getProperty(this.clusterPasswordKey);
        Validate.notEmpty((String)password, (String)(this.clusterPasswordKey + " cannot be empty"));
        config.getGroupConfig().setPassword(password);
    }

    private void configureClusterHost(ClientConfig config, Properties properties) throws IOException {
        int port = this.defaultPort;
        try {
            port = Integer.parseInt(properties.getProperty(this.portKey));
        }
        catch (NumberFormatException e) {
            LOGGER.info((Object)("invalid port number, try to use default: " + e.getLocalizedMessage()));
        }
        Validate.isTrue((port > -1 ? 1 : 0) != 0, (String)"port must be valid: ", (long)port);
        config.getNetworkConfig().addAddress(new String[]{(StringUtils.isBlank((String)this.ip) ? this.getAddress().getHostAddress() : this.ip) + ":" + port});
    }

    @Override
    public ClientConfig build() throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(this.configFile));
        return this.create(props);
    }
}

