package com.tandbergtv.neptune.ui.portalpage.client.ui;


import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.ui.CssButton;
import org.gwtportlets.portlet.client.ui.Dialog;
import org.gwtportlets.portlet.client.util.Rectangle;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.tandbergtv.neptune.ui.portalpage.client.ArrangementEditor;

public class ArrangementEditorControlDialog extends Dialog {

    private final ArrangementEditor manager;

    private FlowPanel rowColumnEditPanel = new FlowPanel();
    private FlowPanel leftPanel = new FlowPanel();
    private FlowPanel rightPanel = new FlowPanel();
    private HTML message = new HTML();

    private String defaultMessage = "Drag portlets to move or resize";
    private String defaultTooltip = "Drag the thick edge of each widget to resize";

    private static final int WIDTH = 700;
    private static final int HEIGHT = 70;

    private ClickHandler editColumnClickListener = new ClickHandler() {
        @Override
        public void onClick(ClickEvent event) {
            Button b = (Button)event.getSource();
            b.setFocus(false);
            manager.setEditDepth(ArrangementEditor.COL_LEVEL);
        }
    };

    private ClickHandler editRowClickListener = new ClickHandler() {
        @Override
        public void onClick(ClickEvent event) {
            Button b = (Button)event.getSource();
            b.setFocus(false);
            manager.setEditDepth(ArrangementEditor.ROW_LEVEL);
        }
    };

    public ArrangementEditorControlDialog(ArrangementEditor manager) {
        super(false, false);
        this.manager = manager;

        setText("Layout Editor");
        setButtonBarVisible(false);
        setMaximizeVisible(false);

        addStyleName("portlet-ed-control");
        rowColumnEditPanel.setStyleName("portlet-ed-control-level");
        leftPanel.setStyleName("portlet-ed-control-left");
        message.setStyleName("portlet-ed-control-message");
        rightPanel.setStyleName("portlet-ed-control-right");

        Grid g = new Grid(1, 1);
        g.setCellPadding(0);
        g.setCellSpacing(0);
        g.setBorderWidth(0);
        g.setHeight("100%");
        g.setWidget(0, 0, message);
        g.getRowFormatter().setVerticalAlign(0,
                HasVerticalAlignment.ALIGN_MIDDLE);
        g.getCellFormatter().setHorizontalAlignment(0, 0,
                HasHorizontalAlignment.ALIGN_CENTER);

        restoreMessage();

        FlowPanel p = new FlowPanel();
        p.add(rowColumnEditPanel);
        p.add(leftPanel);
        p.add(rightPanel);
        p.add(g);
        setWidget(p);

        setPixelSize(WIDTH, HEIGHT);
    }

    @Override
    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        manager.onPreviewNativeEvent(event);
    }

    @Override
    public void onCloseClick() {
        manager.endEditing(true);
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public void setDefaultTooltip(String defaultTooltip) {
        this.defaultTooltip = defaultTooltip;
    }

    private void restoreMessage() {
        message.setHTML(defaultMessage);
        message.setTitle(defaultTooltip);
    }

    /**
     * Sync to our manager and display if not already visible.
     * Limit user editing to level1 (column width) and level2 (row height)
     */
    public void update() {
        rowColumnEditPanel.clear();
        Button btnCol = new CssButton("Resize Columns", editColumnClickListener);
        Button btnRow = new CssButton("Arrange Portlets", editRowClickListener);
        int sel = manager.getEditDepth();
        if (ArrangementEditor.ROW_LEVEL == sel) {
            btnRow.addStyleDependentName("selected");
        } else if (ArrangementEditor.COL_LEVEL == sel) {
            btnCol.addStyleDependentName("selected");
        }
        rowColumnEditPanel.add(btnCol);
        rowColumnEditPanel.add(btnRow);
        show();
    }

    public void initPopupPosition() {
        // try to center above or below the root widget
        Rectangle r = LDOM.getBounds(manager.getRoot().getElement());
        int y = r.y - HEIGHT - 4;
        if (y < 0) { // not enough space above so try below
            y = r.y + r.height + 4;
            if ((y + HEIGHT) > Window.getClientHeight()) {
                y = 0; // give up
            }
        }
        int x = r.x + ((r.width - WIDTH) / 2);
        if (x < 0) {
            x = 0;
        }
        setPopupPosition(x, y);
    }

    /**
     * Display msg and enable the cancel button. If cancel is clicked then
     * onCancel is invoked.
     *
     * @see #endOperation()
     */
    public void beginOperation(String htmlMsg, String tooltip,
            boolean hideLevel, ClickHandler onCancel) {
        message.setHTML(htmlMsg);
        message.setTitle(tooltip);

        Button cancel = new CssButton("Cancel", onCancel);
        cancel.setTitle("Cancel operation (Esc)");
        rightPanel.add(cancel);

        if (hideLevel) {
            rowColumnEditPanel.setVisible(false);
        }
    }

    public void endOperation() {
        rowColumnEditPanel.setVisible(true);
        restoreMessage();
        rightPanel.clear();
    }

    /**
     * This is the panel with the stop button. Add extra stuff here if you
     * need to.
     */
    public FlowPanel getLeftPanel() {
        return leftPanel;
    }

    /**
     * Add extra buttons and so on required by the active operation to this
     * panel. It is cleared by {@link #endOperation()}.
     */
    public FlowPanel getRightPanel() {
        return rightPanel;
    }

    /**
     * Is the level indicator visible?
     */
    public boolean isLevelVisible() {
        return rowColumnEditPanel.isVisible();
    }

}
