/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.util;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationMessage;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ValidationMessageHelper {
    private static final String DEFAULT_LANG = "en";

    public static List<String> formatErrorMessages(List<ValidationResult> erros) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (ValidationResult error : erros) {
            String msg = ValidationMessageHelper.formatErrorMessage(error);
            if (msg == null) continue;
            validationMessages.add(msg);
        }
        return validationMessages;
    }

    public static String formatErrorMessage(ValidationResult error) {
        List<ValidationMessage> vms = error.getMessages();
        ValidationMessage m = null;
        for (ValidationMessage defaultMsg : vms) {
            if (!DEFAULT_LANG.equals(defaultMsg.getLang())) continue;
            m = defaultMsg;
            break;
        }
        if (m == null && !vms.isEmpty()) {
            m = vms.get(0);
        }
        String formattedMessage = null;
        if (m != null) {
            ArrayList<String> params = new ArrayList<String>();
            for (List<LocalizedString> localizedParam : m.getParams()) {
                LocalizedString param = null;
                for (LocalizedString localizedParamString : localizedParam) {
                    if (!DEFAULT_LANG.equals(localizedParamString.getLang())) continue;
                    param = localizedParamString;
                    break;
                }
                if (param == null && !localizedParam.isEmpty()) {
                    param = localizedParam.get(0);
                }
                if (param == null) continue;
                params.add(param.getValue());
            }
            formattedMessage = MessageFormat.format(m.getMessage(), params.toArray());
        }
        return formattedMessage;
    }
}

