/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.audit;

import com.ericsson.neptune.security.audit.AbstractAuditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class FieldReflectionAuditor<T>
extends AbstractAuditor<T> {
    private static Logger logger = Logger.getLogger(FieldReflectionAuditor.class);
    private List<String> propertyNames;
    private ObjectMapper objectMapper;

    protected String auditEntity(T oldEntity, T newEntity) {
        if (this.propertyNames == null || this.propertyNames.isEmpty()) {
            return null;
        }
        HashMap<String, Object> changes = new HashMap<String, Object>(20);
        for (String property : this.propertyNames) {
            if (StringUtils.isBlank((String)property)) continue;
            try {
                this.auditProperty(oldEntity, newEntity, changes, property);
            }
            catch (Exception e) {
                logger.warn((Object)("cannot get property[" + property + "] from " + newEntity), (Throwable)e);
            }
        }
        this.auditAdditionalField(oldEntity, newEntity, changes);
        if (changes.size() > 0) {
            HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>(1);
            result.put(this.getEntityType(), changes);
            try {
                return this.objectMapper.writeValueAsString(result);
            }
            catch (Exception e) {
                logger.warn((Object)"cannot get audit log", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void auditProperty(T oldEntity, T newEntity, Map<String, Object> changes, String property) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        Object newValue = PropertyUtils.getProperty(newEntity, (String)property);
        if (oldEntity == null) {
            changes.put(property, newValue);
        } else {
            Object oldValue = PropertyUtils.getProperty(oldEntity, (String)property);
            if (this.isChanged(oldValue, newValue)) {
                changes.put(property, newValue);
            }
        }
    }

    private boolean isChanged(Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && newValue instanceof Collection) {
            Collection oldCol = (Collection)oldValue;
            Collection newCol = (Collection)newValue;
            return oldCol.size() != newCol.size() || !newCol.containsAll(oldCol);
        }
        return !ObjectUtils.equals((Object)oldValue, (Object)newValue);
    }

    protected abstract void auditAdditionalField(T var1, T var2, Map<String, Object> var3);

    public void setPropertyNames(List<String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

