/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.sync;

import com.ericsson.neptune.http.HttpMethodFactory;
import com.ericsson.neptune.usermgmt.sync.IUserSynchronizer;
import com.tandbergtv.neptune.usermgmt.service.UserSynchronizationException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HttpUserSynchronizerDelegate
implements IUserSynchronizer {
    private static Logger logger = Logger.getLogger(HttpUserSynchronizerDelegate.class);
    private static final String DEFAULT_USER_URL = "/cms/services/users/sync";
    private HttpClient httpClient;
    private HttpMethodFactory httpMethodFactory;
    private String serviceUrl = "/cms/services/users/sync";

    @Override
    public void syncUser(String userId, String credentials) {
        this.syncUser(userId, credentials, Collections.emptyMap());
    }

    @Override
    public void syncUser(String userId, String credentials, Map<String, Object> params) {
        this.doSyncUser(userId, credentials);
    }

    @Override
    public void simpleSyncUser(String userId) throws UserSynchronizationException {
        this.doSyncUser(userId, null);
    }

    private void doSyncUser(String userId, String password) {
        PostMethod post = null;
        try {
            String queryString = "?username=" + userId + (StringUtils.isBlank((String)password) ? "" : "&password=" + password);
            logger.info((Object)("sync user from[" + this.serviceUrl + "?username=" + userId + "]"));
            post = this.httpMethodFactory.post(this.serviceUrl + queryString);
            this.httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() != 200) {
                throw new Exception("cannot synchronize user[" + userId + "], please check server log for more details");
            }
        }
        catch (Exception e) {
            logger.error((Object)"error when synchronizing user", (Throwable)e);
            throw new UserSynchronizationException("cannot synchronize user[" + userId + "]", e);
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpMethodFactory(HttpMethodFactory httpMethodFactory) {
        this.httpMethodFactory = httpMethodFactory;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }
}

