/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.ComplexSetting;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.validator.GroupValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComplexSettingValidator
implements GroupValidator {
    private static final String ARRAYS_REGEX = "(\\[\\d*\\])";
    private static final Pattern ARRAYS_PATTERN = Pattern.compile("(\\[\\d*\\])");
    private SettingGroup group;
    private Map<String, String> values;
    private static final String PATH_SEPARATOR = ".";
    private Set<String> settingsPaths = new TreeSet<String>();
    private Map<String, Integer> arrayLengths = new HashMap<String, Integer>();

    @Override
    public List<ValidationResult> validate(SettingGroup group, Map<String, String> values) {
        this.group = group;
        this.values = values;
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>();
        if (group.getSettings().size() > 0 && group.getSettings().get(0) instanceof ComplexSetting) {
            this.buildSettingsTree("", group.getSettings().get(0));
            this.validateInvalidPaths(errors);
        }
        return errors;
    }

    private void validateArrayBounds(String settingPath, List<ValidationResult> errors) {
        Matcher m = ARRAYS_PATTERN.matcher(settingPath);
        while (m.find()) {
            String arrayName = settingPath.substring(0, m.start());
            String arrayLengthStr = settingPath.substring(m.start() + 1, m.end() - 1);
            int arrayLenght = Integer.parseInt(arrayLengthStr);
            String arrayPath = arrayName.replaceAll("\\[\\d*\\]", "");
            Integer maxLength = this.arrayLengths.get(arrayPath);
            if (maxLength == null) {
                maxLength = -1;
            }
            if (arrayLenght < maxLength) continue;
            ValidationResult result = new ValidationResult();
            ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(3);
            ArrayList<LocalizedString> settingToBeInserted = new ArrayList<LocalizedString>(1);
            settingToBeInserted.add(new LocalizedString(settingPath, "en"));
            params.add(settingToBeInserted);
            ArrayList<LocalizedString> settingInvalidArray = new ArrayList<LocalizedString>(1);
            settingInvalidArray.add(new LocalizedString(arrayName, "en"));
            params.add(settingInvalidArray);
            ArrayList<LocalizedString> arrayOverflow = new ArrayList<LocalizedString>(1);
            arrayOverflow.add(new LocalizedString(maxLength.toString(), "en"));
            params.add(arrayOverflow);
            result.fail().addMessage("{0} is not a valid setting because {1} can not have more than {2} items. ", "en", params);
            errors.add(result);
        }
    }

    private void validateInvalidPaths(List<ValidationResult> errors) {
        for (String settingToBeSaved : this.values.keySet()) {
            Matcher m = ARRAYS_PATTERN.matcher(settingToBeSaved);
            String settingToBeSavedPath = m.replaceAll("");
            if (!this.settingsPaths.contains(settingToBeSavedPath)) {
                ValidationResult result = new ValidationResult();
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(3);
                ArrayList<LocalizedString> settingToBeInserted = new ArrayList<LocalizedString>(1);
                settingToBeInserted.add(new LocalizedString(settingToBeSaved, "en"));
                params.add(settingToBeInserted);
                ArrayList<LocalizedString> settingPath = new ArrayList<LocalizedString>(1);
                settingPath.add(new LocalizedString(settingToBeSavedPath, "en"));
                params.add(settingPath);
                params.add(this.group.getDisplayName());
                result.fail().addMessage("{0} is not a valid setting because {1} is not a valid path in the component {2}. ", "en", params);
                errors.add(result);
                continue;
            }
            this.validateArrayBounds(settingToBeSaved, errors);
        }
    }

    protected void buildSettingsTree(String parent, SettingDefinition def) {
        String settingPath = def.getName();
        if (!parent.isEmpty()) {
            settingPath = parent + PATH_SEPARATOR + def.getName();
        }
        this.settingsPaths.add(settingPath);
        if (def instanceof ComplexSetting) {
            ComplexSetting setting = (ComplexSetting)def;
            if (setting.getMax() == null || setting.getMax() > 1) {
                if (setting.getMax() == null) {
                    this.arrayLengths.put(settingPath, Integer.MAX_VALUE);
                } else {
                    this.arrayLengths.put(settingPath, setting.getMax());
                }
            }
            for (SettingDefinition child : setting.getSettings()) {
                this.buildSettingsTree(settingPath, child);
            }
        }
    }
}

