/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.SettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BasicFileSystemValidator
implements SettingValidator {
    @Override
    public void setOtherSettingsValues(Map<String, String> otherSettingsValues) {
    }

    @Override
    public void setValidatorParameters(Map<String, String> validatorParameters) {
    }

    @Override
    public ValidationResult validate(SettingDefinition setting, String value) {
        ValidationResult result = new ValidationResult();
        ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
        params.add(setting.getDisplayName());
        if (value.isEmpty() || value == null) {
            result.addMessage("{0} setting needs a valid directory path", "en", params);
            return result.fail();
        }
        File directory = new File(value);
        if (!directory.isDirectory()) {
            result.addMessage("{0} setting needs a valid directory path", "en", params);
            return result.fail();
        }
        if (!directory.canRead()) {
            result.addMessage("{0}: " + value + " directory is not accessible", "en", params);
            return result.fail();
        }
        if (!directory.canWrite()) {
            result.addMessage("{0}: " + value + " directory does not have write permission", "en", params);
            return result.fail();
        }
        return result.success();
    }
}

