package com.tandbergtv.neptune.ui.realm.client.tab.user.model;

import java.util.HashSet;
import java.util.Set;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;

public class UiUser implements IsSerializable {
	private UiUserKey key = new UiUserKey();
	private String externalKey;
	private String userName;
	private String password;
	private boolean active = true;
	private String firstName;
	private String lastName;
	private String email;
	private String phone;
	private String extension;
	private String employeeId;
	private String department;
	private String location;
	private Set<UiRole> roles = new HashSet<UiRole>();
	private boolean changePassword = false;
	private boolean adminUser = false;
	private boolean externallyAuthenticated = false;
	private boolean isExternalLdapUser = false;

	public UiUser() {
	}

	public Long getId() {
		return this.key.getId();
	}

	public void setId(Long id) {
		this.key.setId(id);
	}

	public String getExternalKey() {
		return this.externalKey;
	}

	public void setExternalKey(String externalKey) {
		this.externalKey = externalKey;
	}

	public UiUserKey getKey() {
		return key;
	}

	public void setKey(UiUserKey key) {
		if (key == null)
			key = new UiUserKey();

		this.key = key;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(String employeeId) {
		this.employeeId = employeeId;
	}

	public String getDepartment() {
		return department;
	}

	public void setDepartment(String department) {
		this.department = department;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public Set<UiRole> getRoles() {
		return this.roles;
	}

	public void setRoles(Set<UiRole> roles) {
		this.roles = roles;
	}

	/**
	 * @return the changePassword
	 */
	public boolean isChangePassword() {
		return changePassword;
	}

	/**
	 * @param changePassword the changePassword to set
	 */
	public void setChangePassword(boolean changePassword) {
		this.changePassword = changePassword;
	}

	/**
	 * Determine if the user is a system admin user
	 * 
	 * @return true if admin user, false otherwise
	 */
	public boolean isAdminUser() {
		return adminUser;
	}

	/**
	 * Set if the user is a system admin user
	 * 
	 * @param adminUser true if admin user, false otherwise
	 */
	public void setAdminUser(boolean adminUser) {
		this.adminUser = adminUser;
	}

	/**
	 * Determine if the user is externally authenticated
	 * 
	 * @return true if externally authenticated, false otherwise
	 */
	public boolean isExternallyAuthenticated() {
		return externallyAuthenticated;
	}

	/**
	 * Set the user external authentication flag
	 * 
	 * @param externallyAuthenticated true for external authentication, false otherwise
	 */
	public void setExternallyAuthenticated(boolean externallyAuthenticated) {
		this.externallyAuthenticated = externallyAuthenticated;
	}

	public boolean isExternalLdapUser() {
		return isExternalLdapUser;
	}

	public void setExternalLdapUser(boolean isExternalLdapUser) {
		this.isExternalLdapUser = isExternalLdapUser;
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return key.hashCode() + 31;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (!(obj instanceof UiUser))
			return false;

		/* Must have the same keys */
		UiUser other = (UiUser) obj;
		return key.equals(other.key);
	}
}
