package com.tandbergtv.neptune.ui.realm.client.settings.service;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;

/**
 * Asynchronous interface for {@link ISettingsUIService} RPC service.
 * @author Francisco Bento da Silva Neto
 *
 */
public interface ISettingsUIServiceAsync extends RemoteService {

    /**
     * @see ISettingsUIService#getAllSettingDefinitions()
     */
    void getAllSettingDefinitions(AsyncCallback<List<UiSettingGroup>> callback);

    /**
     * @see ISettingsUIService#findSettingDefinitions(String)
     */
    void findSettingDefinitions(String filter, AsyncCallback<List<UiSettingGroup>> callback);

    /**
     * @see ISettingsUIService#getSettingsValues(String)
     */
    void getSettingsValues(String path, AsyncCallback<Map<String, String>> callback);

    void getTokenAndSettings(String settingsPath, AsyncCallback<UiTokenAndSettings> callback);

    /**
     * @see ISettingsUIService#saveSettings(UiSettingGroup, Map)
     */
    void saveSettings(UiSettingGroup group, Map<String, String> values, AsyncCallback<Void> callback);

    /**
     * @see ISettingsUIService#validateSettingGroup(String)
     */
    void validateSettingGroup(String group, AsyncCallback<List<String>> callback);

    /**
     * @see ISettingsUIService#hasInconsistentGroups()
     */
    void hasInconsistentGroups(AsyncCallback<Boolean> callback);
}
