/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link PushButton} widget.
 * 
 * @see com.google.gwt.user.client.ui.PushButton
 * @author Vijay Silva
 */
public class PushButtonWidget extends PushButton implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton()
	 */
	public PushButtonWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(String)
	 */
	public PushButtonWidget(String upText) {
		super(upText);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(String, String)
	 */
	public PushButtonWidget(String upText, String downText) {
		super(upText, downText);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(Image)
	 */
	public PushButtonWidget(ImageWidget upImage) {
		super(upImage);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(Image, Image)
	 */
	public PushButtonWidget(ImageWidget upImage, ImageWidget downImage) {
		super(upImage, downImage);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(Image, ClickHandler)
	 */
	public PushButtonWidget(String upText, ClickHandler handler) {
		super(upText, handler);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(String, String, ClickHandler)
	 */
	public PushButtonWidget(String upText, String downText, ClickHandler handler) {
		super(upText, downText, handler);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(Image, ClickHandler)
	 */
	public PushButtonWidget(ImageWidget upImage, ClickHandler handler) {
		super(upImage, handler);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.PushButton#PushButton(Image, Image, ClickHandler)
	 */
	public PushButtonWidget(ImageWidget upImage, ImageWidget downImage, ClickHandler handler) {
		super(upImage, downImage, handler);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
