package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

/**
 * Adds the ability to page through data in the table.
 */
public interface PageFeature extends Feature {

	/**
	 * Get the default page size
	 * 
	 * @return The default page size
	 */
	int getDefaultPageSize();

	/**
	 * Get the current page number (1-based)
	 * 
	 * @return The page number
	 */
	int getPageNumber();

	/**
	 * Set the current page number
	 * 
	 * @param pageNumber The page number
	 */
	void setPageNumber(int pageNumber);

	/**
	 * Get the page size
	 * 
	 * @return The page size
	 */
	int getPageSize();

	/**
	 * Set the page size
	 * 
	 * @param pageSize page size
	 */
	void setPageSize(int pageSize);

	/**
	 * Get the record count
	 * 
	 * @return Get the total number of records that the search returns
	 */
	int getRecordCount();

	/**
	 * Set the total record count
	 * 
	 * @param recordCount The record count
	 */
	void setRecordCount(int recordCount);

	/**
	 * Get the allowed page sizes. Once the feature added to the table, this list should not be
	 * changed
	 * 
	 * @return The array of allowed page sizes.
	 */
	int[] getPageSizes();

	/**
	 * Gets the flag indicating whether there are more pages to show records
	 * 
	 * @return
	 */
	boolean hasMorePages();

	/**
	 * Sets the flag indicating whether there are more pages to show records
	 * 
	 * @param hasMorePages
	 */
	void setHasMorePages(boolean hasMorePages);

	/**
	 * Flag used to determine whether a simple paging widget is required or one which displays the
	 * total number of pages. When this flag is false, the table widget assumes that the total page
	 * count cannot be calculated.
	 * 
	 * @return Flag indicating if the total count is available
	 */
	boolean showTotalCount();

	/**
	 * Sets the flag indicating whether or not to display the total page count.
	 * 
	 * @param showTotalCount Flag indicating that the total count is available
	 */
	void setShowTotalCount(boolean showTotalCount);
}
