/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.actions;

import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.actions.NormalizationChangeAction;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.marvin.udt.GenericType;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

@ActionAnnotations(name="NORMALIZATION")
public class NormalizationActions
extends Action {
    private static final String CATEGORY_SEPERATOR = "/";
    private List<ActionMessage> messages = new ArrayList<ActionMessage>();
    private static final String CATEGORY_XPATH = "/tns:Fields/tns:Category/tns:Text";

    @ActionAnnotations.Action(name="normalizationChangeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING, GenericType.DataTypes.FLOAT, GenericType.DataTypes.LONG, GenericType.DataTypes.BOOLEAN, GenericType.DataTypes.DATE, GenericType.DataTypes.TIME}, valueType={GenericType.DataTypes.STRING, GenericType.DataTypes.FLOAT, GenericType.DataTypes.LONG, GenericType.DataTypes.BOOLEAN, GenericType.DataTypes.DATE, GenericType.DataTypes.TIME})
    public void change(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        NormalizationChangeAction changer = new NormalizationChangeAction(sectionType, rootxpath, xpath, forMatched, value, evalResults, title);
        changer.change();
    }

    @ActionAnnotations.Action(name="normalizationPrefixLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void prefix(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            field.setTypedValue((Object)(String.valueOf(value.getStringValue()) + field.getValue()));
        }
    }

    @ActionAnnotations.Action(name="normalizationAppendLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void append(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            field.setTypedValue((Object)(String.valueOf(field.getValue()) + value.getStringValue()));
        }
    }

    @ActionAnnotations.Action(name="normalizationTruncateLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.LONG})
    public void truncate(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            int endIndex;
            String str = field.getValue();
            long longValue = value.getLongValue();
            if (longValue < 0L) {
                endIndex = 0;
            } else {
                int n = endIndex = longValue >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longValue;
            }
            if (str.length() < endIndex) {
                endIndex = str.length();
                continue;
            }
            if (endIndex < 1) {
                this.remove(sectionType, rootxpath, xpath, forMatched, evalResults, title);
                continue;
            }
            field.setTypedValue((Object)str.substring(0, endIndex));
        }
    }

    @ActionAnnotations.Action(name="normalizationMultiplyLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT}, valueType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT})
    public void multiply(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                fieldValue = (Float)field.getTypedValue();
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(((Float)fieldValue).floatValue() * value.getFloatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() * value.getLongValue();
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationSubtractLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT}, valueType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT})
    public void subtract(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                fieldValue = (Float)field.getTypedValue();
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(((Float)fieldValue).floatValue() - value.getFloatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() - value.getLongValue();
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationAddLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT}, valueType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT})
    public void add(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                fieldValue = (Float)field.getTypedValue();
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(((Float)fieldValue).floatValue() + value.getFloatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() + value.getLongValue();
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationDivideLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT}, valueType={GenericType.DataTypes.LONG, GenericType.DataTypes.FLOAT})
    public void divide(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        if (value.getDataType().equals((Object)GenericType.DataTypes.FLOAT) && value.getFloatValue() == 0.0f || value.getDataType().equals((Object)GenericType.DataTypes.LONG) && value.getLongValue() == 0L) {
            return;
        }
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            Number fieldValue;
            if (field.getDataType().equals("float")) {
                fieldValue = (Float)field.getTypedValue();
                if (Float.isInfinite(((Float)(fieldValue = Float.valueOf(((Float)fieldValue).floatValue() / value.getFloatValue()))).floatValue())) continue;
                field.setTypedValue((Object)fieldValue);
                continue;
            }
            if (!field.getDataType().equals("integer")) continue;
            fieldValue = (Long)field.getTypedValue();
            fieldValue = (long)((Long)fieldValue).intValue() / value.getLongValue();
            field.setTypedValue((Object)fieldValue);
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "matchedItems", "title"}, parmLabels={"", "", "", "", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.NULL, GenericType.DataTypes.STRING, GenericType.DataTypes.FLOAT, GenericType.DataTypes.LONG, GenericType.DataTypes.DATE, GenericType.DataTypes.BOOLEAN, GenericType.DataTypes.TIME}, valueType={GenericType.DataTypes.NULL, GenericType.DataTypes.NULL, GenericType.DataTypes.NULL, GenericType.DataTypes.NULL, GenericType.DataTypes.NULL, GenericType.DataTypes.NULL, GenericType.DataTypes.NULL})
    public void remove(String sectionType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title) {
        if (forMatched.booleanValue() && (sectionType.equals(xpath) || xpath == null)) {
            this.removeAssets(evalResults.getMatchedAssets());
        } else if (sectionType.equals(xpath) || xpath == null) {
            this.removeAssets(title.getAsset().getAllAssetsOfType(sectionType));
        } else {
            List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, true);
            for (Field field : fields) {
                field.getParentAsset().getFields().remove(field);
            }
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""}, xpathFilter={})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void replace(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, GenericType value2, EvaluatorResults evalResults, Title title) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String val = field.getValue().replace(value.getStringValue(), value2.getStringValue());
            field.setValue(val);
        }
    }

    @ActionAnnotations.Action(name="normalizationInsertBeforeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "insert", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void InsertBefore(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, GenericType value2, EvaluatorResults evalResults, Title title) {
        String find = value.getStringValue();
        String insert = value2.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            String result = "";
            int i = 0;
            while (i < categoryList.size()) {
                if (categoryList.get(i).equals(find)) {
                    if (i > 0) {
                        result = String.valueOf(result) + CATEGORY_SEPERATOR;
                    }
                    result = String.valueOf(result) + insert;
                    if (i == 0) {
                        result = String.valueOf(result) + CATEGORY_SEPERATOR;
                    }
                }
                if (i > 0) {
                    result = String.valueOf(result) + CATEGORY_SEPERATOR;
                }
                result = String.valueOf(result) + categoryList.get(i);
                ++i;
            }
            field.setValue(result);
        }
    }

    @ActionAnnotations.Action(name="normalizationInsertAfterLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "insert", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void InsertAfter(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, GenericType value2, EvaluatorResults evalResults, Title title) {
        String find = value.getStringValue();
        String insert = value2.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            String result = "";
            int i = 0;
            while (i < categoryList.size()) {
                if (i > 0) {
                    result = String.valueOf(result) + CATEGORY_SEPERATOR;
                }
                result = String.valueOf(result) + categoryList.get(i);
                if (categoryList.get(i).equals(find)) {
                    result = String.valueOf(result) + CATEGORY_SEPERATOR;
                    result = String.valueOf(result) + insert;
                }
                ++i;
            }
            field.setValue(result);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceBeforeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void ReplaceBefore(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, GenericType value2, EvaluatorResults evalResults, Title title) {
        String find = value.getStringValue();
        String replace = value2.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            int i = 0;
            while (i < categoryList.size()) {
                if (categoryList.get(i).equals(find) && i > 0) {
                    categoryList.set(i - 1, replace);
                }
                ++i;
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceAfterLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "value2", "matchedItems", "title"}, parmLabels={"", "", "", "", "find", "replace", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void ReplaceAfter(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, GenericType value2, EvaluatorResults evalResults, Title title) {
        String find = value.getStringValue();
        String replace = value2.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            int i = 0;
            while (i < categoryList.size()) {
                if (categoryList.get(i).equals(find) && i < categoryList.size() - 1) {
                    categoryList.set(i + 1, replace);
                }
                ++i;
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveBeforeLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void RemoveBefore(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        String find = value.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            int i = 0;
            while (i < categoryList.size()) {
                if (categoryList.get(i).equals(find) && i > 0) {
                    categoryList.remove(i - 1);
                    --i;
                }
                ++i;
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    @ActionAnnotations.Action(name="normalizationRemoveAfterLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void RemoveAfter(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        String find = value.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            List<String> categoryList = this.breakApartCategory(field.getValue());
            int i = 0;
            while (i < categoryList.size()) {
                if (categoryList.get(i).equals(find) && i < categoryList.size() - 1) {
                    categoryList.remove(i + 1);
                }
                ++i;
            }
            field.setValue(this.buildCategory(categoryList));
        }
    }

    private String buildCategory(List<String> category) {
        String result = "";
        int i = 0;
        while (i < category.size()) {
            if (i > 0) {
                result = String.valueOf(result) + CATEGORY_SEPERATOR;
            }
            result = String.valueOf(result) + category.get(i);
            ++i;
        }
        return result;
    }

    private List<String> breakApartCategory(String category) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(category, CATEGORY_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    @ActionAnnotations.Action(name="normalizationAddTopLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void AddTop(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        String top = value.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (!category.startsWith(CATEGORY_SEPERATOR)) {
                category = CATEGORY_SEPERATOR + category;
            }
            field.setValue(String.valueOf(top) + category);
        }
    }

    @ActionAnnotations.Action(name="normalizationAddChildLabel", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void AddChild(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        String child = value.getStringValue();
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            String category = field.getValue();
            if (!category.endsWith(CATEGORY_SEPERATOR)) {
                category = String.valueOf(category) + CATEGORY_SEPERATOR;
            }
            field.setValue(String.valueOf(category) + child);
        }
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier1Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void replaceTier1(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 1);
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier2Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void replaceTier2(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 2);
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier3Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void replaceTier3(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 3);
    }

    @ActionAnnotations.Action(name="normalizationReplaceTier4Label", parms={"sectionType", "rootxpath", "xpath", "forMatched", "value", "matchedItems", "title"}, parmLabels={"", "", "", "", "", "", ""}, xpathFilter={"/tns:Fields/tns:Category/tns:Text"})
    @ActionAnnotations.GenericTypeMapping(dataType={GenericType.DataTypes.STRING}, valueType={GenericType.DataTypes.STRING})
    public void replaceTier4(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title) {
        this.replaceTier(sectionType, rootxpath, xpath, forMatched, value, evalResults, title, 4);
    }

    private void replaceTier(String sectionType, String rootxpath, String xpath, Boolean forMatched, GenericType value, EvaluatorResults evalResults, Title title, int tier) {
        List<Field> fields = this.findFields(sectionType, rootxpath, xpath, forMatched, evalResults, title, false);
        for (Field field : fields) {
            StringTokenizer tokenizer = new StringTokenizer(field.getValue(), CATEGORY_SEPERATOR);
            int currTier = 1;
            String newVal = "";
            while (currTier < tier && tokenizer.hasMoreTokens()) {
                if (currTier > 1) {
                    newVal = String.valueOf(newVal) + CATEGORY_SEPERATOR;
                }
                newVal = String.valueOf(newVal) + tokenizer.nextToken();
                ++currTier;
            }
            if (tokenizer.hasMoreTokens()) {
                if (currTier > 1) {
                    newVal = String.valueOf(newVal) + CATEGORY_SEPERATOR;
                }
                newVal = String.valueOf(newVal) + value.getStringValue();
                tokenizer.nextToken();
                ++currTier;
            }
            while (tokenizer.hasMoreTokens()) {
                if (currTier > 1) {
                    newVal = String.valueOf(newVal) + CATEGORY_SEPERATOR;
                }
                newVal = String.valueOf(newVal) + tokenizer.nextToken();
                ++currTier;
            }
            field.setValue(newVal);
        }
    }

    private void removeAssets(List<Asset> assetsToRemove) {
        for (Asset assetToRemove : assetsToRemove) {
            List potentialParents = assetToRemove.getRoot().getAllDescendantItems(true);
            potentialParents.add(assetToRemove.getRoot());
            for (Asset potParent : potentialParents) {
                if (potParent.equals(assetToRemove)) continue;
                Iterator parentRelationIterator = potParent.getRelations().iterator();
                while (parentRelationIterator.hasNext()) {
                    Relation r = (Relation)parentRelationIterator.next();
                    if (r.getTargetAsset().getId() != assetToRemove.getId() && r.getOwnerAsset().getId() != assetToRemove.getId()) continue;
                    parentRelationIterator.remove();
                }
            }
        }
    }

    public void printMessages() {
        for (ActionMessage message : this.messages) {
            System.out.println(message.getMessage());
        }
    }

    public void cleanUpAction() {
        this.printMessages();
    }

    public void setMessages(List<ActionMessage> messages) {
        this.messages = messages;
    }

    public List<ActionMessage> getMessages() {
        return this.messages;
    }

    private List<Field> findFields(String assetType, String rootxpath, String xpath, Boolean forMatched, EvaluatorResults evalResults, Title title, boolean addChildren) {
        List<FieldTree> matchedFieldTrees = evalResults.getMatchedItems();
        List<Asset> matchedAssets = evalResults.getMatchedAssets();
        List<Object> fields = new ArrayList<Field>();
        if (forMatched.booleanValue() && rootxpath != null && !rootxpath.equals(assetType)) {
            for (FieldTree fieldTree : matchedFieldTrees) {
                List ftn = fieldTree.toList();
                if (!fieldTree.getRootElement().getName().equals(rootxpath)) continue;
                for (FieldTreeNode node : ftn) {
                    Field field = node.getField();
                    if (field == null || !field.getParentAsset().getAssetType().equals(assetType)) continue;
                    if (field.getTtvXPath().equals(xpath)) {
                        fields.add(field);
                        continue;
                    }
                    if (!addChildren || !field.getTtvXPath().startsWith(String.valueOf(xpath) + CATEGORY_SEPERATOR)) continue;
                    fields.add(field);
                }
            }
        } else if (forMatched.booleanValue() && matchedAssets != null && matchedAssets.size() > 0) {
            for (Asset asset : matchedAssets) {
                if (!asset.getAssetType().equals(assetType)) continue;
                fields.addAll(this.getFieldsForXpath(asset, xpath));
            }
        } else if (!forMatched.booleanValue()) {
            fields = title.getAsset().getAllFieldsForXpath(assetType, xpath);
        }
        return fields;
    }

    private ArrayList<Field> getFieldsForXpath(Asset asset, String xpath) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (!f.getTtvXPath().startsWith(xpath)) continue;
            list.add(f);
        }
        return list;
    }
}

