/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import java.util.ArrayList;
import java.util.List;

public class BooleanDeterminating
implements IDeterminating {
    private Field field;
    private TrePredicate predicate;

    public BooleanDeterminating(TrePredicate predicate, Field field) throws EvaluatorException {
        this.field = field;
        this.predicate = predicate;
    }

    private Boolean geBooleanLhs() throws EvaluatorException {
        if (this.containsUnparsable() || this.field == null) {
            return null;
        }
        return (Boolean)this.field.getTypedValue();
    }

    private Boolean getRhsAsBoolean() throws EvaluatorException {
        List<Boolean> list = this.getRhsAsBooleanList();
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().getName() + " has a list as a RHS.");
    }

    private List<Boolean> getRhsAsBooleanList() throws EvaluatorException {
        TrePredicateRightValue rightPredicate = (TrePredicateRightValue)this.predicate;
        if (rightPredicate.getValue().size() == 0) {
            throw new EvaluatorException("Predicate with ID and operator " + this.predicate.getOperator().getName() + " is missing a RHS.");
        }
        try {
            ArrayList<Boolean> ints = new ArrayList<Boolean>();
            for (String predVal : rightPredicate.getValue()) {
                ints.add(Boolean.parseBoolean(predVal));
            }
            return ints;
        }
        catch (NumberFormatException e) {
            throw new EvaluatorException("value must be a boolean number", e);
        }
    }

    @Override
    public boolean equal() throws EvaluatorException {
        Boolean lhs = this.geBooleanLhs();
        return lhs != null && lhs.equals(this.getRhsAsBoolean());
    }

    @Override
    public boolean greaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean greaterThanEqual() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean in() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean isEmpty() throws IllegalOperationException {
        return this.field == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.field != null;
    }

    @Override
    public boolean lessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanEqual() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean contains() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean notEqual() throws IllegalOperationException, EvaluatorException {
        return !this.equal();
    }

    @Override
    public boolean notIn() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.field == null) {
            return false;
        }
        return this.field.getParsable() == false;
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        throw new IllegalOperationException();
    }
}

