/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.DateDeterminating;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class DateDeterminatingTest {
    public void testDateEqualTrue() throws Exception {
        TrePredicateRightValue pred = this.getDatePredicate("2009-09-13");
        Field field = this.getDateField("2009-09-13");
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field);
        Assert.assertTrue((boolean)det.equal());
    }

    public void testDateEqualFalse() throws Exception {
        Field field;
        TrePredicateRightValue pred = this.getDatePredicate("2009-09-13");
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field = this.getDateField("2009-09-12"));
        Assert.assertTrue((!det.equal() ? 1 : 0) != 0);
    }

    public void testDateNotEqual() throws Exception {
        Field field;
        TrePredicateRightValue pred = this.getDatePredicate("2009-09-13");
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field = this.getDateField("2009-09-12"));
        Assert.assertTrue((!det.equal() ? 1 : 0) != 0);
    }

    @Test
    public void testDateGreaterThan() throws Exception {
        TrePredicateRightValue pred = this.getDatePredicate("2009-09-12");
        Field field = this.getDateField("2009-09-13");
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field);
        Assert.assertTrue((boolean)det.greaterThan());
    }

    @Test
    public void testDateGreaterThanToday() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, -120);
        int i = 0;
        while (i < 5) {
            cal.add(10, 24);
            this.testGreaterThan(this.getStringFromDate(cal.getTime()), -1);
            ++i;
        }
        cal.setTime(new Date());
        i = 0;
        while (i < 5) {
            cal.add(10, 24);
            this.testGreaterThan(this.getStringFromDate(cal.getTime()), 1);
            ++i;
        }
    }

    private void testGreaterThan(String date, int n) throws Exception {
        System.out.println("TESTCASE: Field='" + date + "' n=" + n);
        TrePredicateRightValue pred = this.getDatePredicate(n);
        Field field = this.getDateField(date);
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field);
        String cmp = this.getStringFromDate(det.getComparison());
        String val = this.getStringFromDate(det.getValue());
        System.out.println("    " + val + " > " + cmp + " -> " + det.greaterThanToday());
    }

    private void testLessThan(String date, int n) throws Exception {
        System.out.println("TESTCASE: Field='" + date + "' n=" + n);
        TrePredicateRightValue pred = this.getDatePredicate(n);
        Field field = this.getDateField(date);
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field);
        String cmp = this.getStringFromDate(det.getComparison());
        String val = this.getStringFromDate(det.getValue());
        System.out.println("    " + val + " < " + cmp + " -> " + det.lessThanToday());
    }

    @Test
    public void testDateLessThanToday() throws Exception {
        TrePredicateRightValue pred = this.getDatePredicate(1);
        Field field = this.getDateField("2009-09-13");
        DateDeterminating det = new DateDeterminating((TrePredicate)pred, field);
        Assert.assertTrue((boolean)det.lessThanToday());
    }

    private Date getDateFromString(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(date);
    }

    private String getStringFromDate(Date date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private Field getDateField(String date) throws ParseException {
        Field field = new Field();
        field.setDataType("date");
        field.setTypedValue((Object)this.getDateFromString(date));
        return field;
    }

    private TrePredicateRightValue getDatePredicate(String date) {
        TrePredicateRightValue pred = new TrePredicateRightValue();
        pred.setDataType("date");
        pred.addValue(date);
        return pred;
    }

    private TrePredicateRightValue getDatePredicate(Integer relative) {
        TrePredicateRightValue pred = new TrePredicateRightValue();
        pred.setDataType("string");
        pred.addValue(relative.toString());
        return pred;
    }
}

