/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.event;

import com.tandbergtv.cms.contentmgmt.service.asset.ITitleSearchService;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.RuleExecutionException;
import com.tandbergtv.marvin.engine.Evaluator;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.SearchField;
import com.tandbergtv.watchpoint.pmm.title.search.SearchFieldNode;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchCriteriaBuilder;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;

@Stateless
public class EventHandler
implements IRuleExecutionHandler {
    private static final Logger logger = Logger.getLogger(EventHandler.class);
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    private ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearch/local", ITitleSearchService.class);

    public RuleResults runRuler(Title title, TreEvent event) {
        logger.info((Object)("Running rules for event: " + (event == null ? "null" : event.getName())));
        TrePackage tp = new TrePackage();
        tp.setName("PROCESSING");
        return this.runRuler(title, event, tp);
    }

    public RuleResults runRuler(Title title, List<Integer> ruleSetIds) {
        logger.info((Object)("Running rule sets: " + (ruleSetIds == null ? "null" : ruleSetIds)));
        List ruleSets = this.ruleManager.getRuleSets(ruleSetIds);
        return this.runRuler(title, ruleSets);
    }

    public RuleResults runRuler(Title title, TrePackage tpackage) {
        logger.info((Object)("Running rules of type: " + (tpackage == null ? "null" : tpackage.getName())));
        List setOfRuleSets = this.ruleManager.getRulesByPackage(tpackage.getName());
        return this.runRuler(title, setOfRuleSets);
    }

    public RuleResults runRuler(Title title, TreEvent event, TrePackage tpackage) {
        logger.info((Object)("Running rules of type: " + (tpackage == null ? "null" : tpackage.getName()) + " for event: " + (event == null ? "null" : event.getName())));
        List setOfRuleSets = this.ruleManager.getRuleByPackageAndEvent(tpackage.getName(), event.getName());
        return this.runRuler(title, setOfRuleSets);
    }

    public RuleResults runNationalizeRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("NORMALIZATION");
        return this.runRuler(title, tp);
    }

    public RuleResults runNationalizeRuler(Title title, TreEvent event) {
        TrePackage tp = new TrePackage();
        tp.setName("NORMALIZATION");
        return this.runRuler(title, event, tp);
    }

    public RuleResults runProcessContentRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("PROCESSING");
        return this.runRuler(title, tp);
    }

    public RuleResults runValidateRuler(Title title) {
        TrePackage tp = new TrePackage();
        tp.setName("VALIDATION");
        return this.runRuler(title, tp);
    }

    public RuleResults runRuler(Title title, Collection<TreRuleSet> ruleSet) {
        RuleResults results = new RuleResults(title);
        Evaluator e = new Evaluator();
        for (TreRuleSet rs : ruleSet) {
            try {
                results.addRuleTypeRun(rs.getTpackage());
                if (!rs.getEnabled().booleanValue() || !e.evaluateTitleFilter(rs, title)) continue;
                results.merge(e.evaluateRules(rs, title));
            }
            catch (Exception ex) {
                RuleExecutionException ex1 = new RuleExecutionException("An error occured while try to run RuleSet: " + rs.getRuleSetId(), (Throwable)ex);
                throw ex1;
            }
        }
        return results;
    }

    @TransactionAttribute
    public List<RuleResults> runRuler() {
        Collection titles = new ArrayList();
        SearchCriteria sc = TitleSearchCriteriaBuilder.getCriteria((boolean)true, null, (String)"Title", (SearchFieldNode)new SearchField(), (int)0, (int)0, (String)"Title", null, null);
        titles = this.searchService.search(sc);
        ArrayList<RuleResults> result = new ArrayList<RuleResults>();
        for (Title title : titles) {
            RuleResults rr = this.runValidateRuler(title);
            rr.merge(this.runNationalizeRuler(title));
            rr.merge(this.runProcessContentRuler(title));
            result.add(rr);
        }
        return result;
    }
}

