/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.MatchedItemTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.XmlTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import java.util.List;

public class NormalizationActionXmlSelection
extends PopupContainer
implements ClickHandler,
SelectionHandler<TreeItem> {
    private static final String PACKAGE = "PACKAGE";
    private TreeWidget tree;
    private NormalizationActionBox actionBox;
    private TreeItem matchedItem;
    private static List<TreeItem> nonMatchedTreeItem;
    private static TreeWidget lastActiveTree;
    private TitleConstants titleConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private TreeItem selectedItem;
    private ScrollContainer sc;
    private Timer timer;
    private int currentPosition = 0;

    public NormalizationActionXmlSelection(NormalizationActionBox actionBox) {
        this.actionBox = actionBox;
        this.tree = new TreeWidget();
        this.tree.addSelectionHandler((SelectionHandler)this);
        this.matchedItem = new TreeItem(this.titleConstants.matched());
        this.tree.addItem(this.matchedItem);
        if (nonMatchedTreeItem == null || nonMatchedTreeItem.isEmpty()) {
            UIAssetSpecification spec = RulesComponent.getInstance().getSpecification();
            nonMatchedTreeItem = TreeCreator.populateTree((UIAssetSpecification)spec);
        }
        this.sc = new ScrollContainer();
        this.sc.setSize("250px", "200px");
        this.sc.add((Widget)this.tree);
        this.timer = new Timer(){

            public void run() {
                NormalizationActionXmlSelection.this.sc.setScrollPosition(NormalizationActionXmlSelection.this.currentPosition);
            }
        };
        this.addScrollHack();
        this.add((Widget)this.sc);
    }

    private void addScrollHack() {
        this.tree.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                NormalizationActionXmlSelection.this.currentPosition = NormalizationActionXmlSelection.this.sc.getScrollPosition();
            }
        });
        this.tree.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                NormalizationActionXmlSelection.this.timer.schedule(5);
            }
        });
    }

    public void setFieldItem(String assetType, String xpath, String rootxpath, boolean forMatched) {
        this.selectedItem = forMatched ? this.findMatchedFieldItem(assetType, rootxpath, xpath) : this.findNonMatchedItem(assetType, xpath);
        this.actionBox.updateFields((XmlTreeObject)this.selectedItem.getUserObject());
    }

    public void setFieldItem(String assetType, String xpath) {
        this.setFieldItem(assetType, xpath, null, false);
    }

    private TreeItem findFieldItem(TreeItem root, String assetType, String xpath) {
        XmlTreeObject rootObj = (XmlTreeObject)root.getUserObject();
        if (rootObj.getAssetType().equals(assetType) && rootObj.getXpath().equals(xpath)) {
            return root;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            TreeItem item = this.findFieldItem(root.getChild(i), assetType, xpath);
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private TreeItem findNonMatchedItem(String assetType, String xpath) {
        for (TreeItem item : nonMatchedTreeItem) {
            TreeItem foundItem = this.findFieldItem(item, assetType, xpath);
            if (foundItem == null) continue;
            return foundItem;
        }
        return null;
    }

    public void setFieldItem(XmlTreeObject treeObject) {
        if (treeObject instanceof MatchedItemTreeObject) {
            MatchedItemTreeObject mto = (MatchedItemTreeObject)treeObject;
            this.setFieldItem(mto.getAssetType(), mto.getXpath(), mto.getParent().getXpath(), true);
        } else {
            this.setFieldItem(treeObject.getAssetType(), treeObject.getXpath());
        }
    }

    private TreeItem findMatchedFieldItem(String assetType, String rootxpath, String xpath) {
        int i = 0;
        while (i < this.matchedItem.getChildCount()) {
            TreeItem item;
            MatchedItemTreeObject treeObj = (MatchedItemTreeObject)this.matchedItem.getChild(i).getUserObject();
            if (treeObj.getXpath().equals(rootxpath) && (item = this.findFieldItem(this.matchedItem.getChild(i), assetType, xpath)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void expandParents(TreeItem item) {
        if (item.getParentItem() != null) {
            TreeItem p = item.getParentItem();
            p.setState(true);
            this.expandParents(p);
        }
    }

    private void collapseTree() {
        int i = 0;
        while (i < this.tree.getItemCount()) {
            this.collapseTreeItem(this.tree.getItem(i));
            ++i;
        }
    }

    private void collapseTreeItem(TreeItem item) {
        if (item.getState()) {
            item.setState(false);
            int i = 0;
            while (i < item.getChildCount()) {
                this.collapseTreeItem(item.getChild(i));
                ++i;
            }
        }
    }

    public void addMatchedItemToTree(TreeItem item) {
        XmlTreeObject fieldObject = (XmlTreeObject)item.getUserObject();
        int i = 0;
        while (i < this.matchedItem.getChildCount()) {
            if (this.matchedItem.getChild(i).getUserObject().equals(fieldObject)) {
                return;
            }
            ++i;
        }
        TreeItem stub = TreeCreator.cloneMatchedItemRootAssetType((TreeItem)item);
        this.matchedItem.addItem(stub);
    }

    public void removeMatchedItemFromTree(XmlTreeObject fieldObject) {
        int i = 0;
        while (i < this.matchedItem.getChildCount()) {
            if (this.matchedItem.getChild(i).getUserObject().equals(fieldObject)) {
                this.matchedItem.removeItem(this.matchedItem.getChild(i));
                break;
            }
            ++i;
        }
    }

    public void onClick(ClickEvent event) {
        if (lastActiveTree == null || lastActiveTree != this.tree) {
            for (TreeItem item : nonMatchedTreeItem) {
                this.tree.addItem(item);
            }
            this.collapseTree();
            if (this.selectedItem != null) {
                this.tree.setSelectedItem(this.selectedItem);
                this.expandParents(this.selectedItem);
            }
            lastActiveTree = this.tree;
        }
        final Widget widget = (Widget)event.getSource();
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                NormalizationActionXmlSelection.this.setPopupPosition(widget.getAbsoluteLeft(), widget.getAbsoluteTop());
            }
        });
        this.actionBox.getRule().clearWarningMessages();
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        TreeItem item = (TreeItem)event.getSelectedItem();
        if ((XmlTreeObject)item.getUserObject() == null) {
            return;
        }
        String assetType = ((XmlTreeObject)item.getUserObject()).getAssetType();
        String xpath = ((XmlTreeObject)item.getUserObject()).getXpath();
        if (assetType.equalsIgnoreCase(PACKAGE) && xpath.equalsIgnoreCase(PACKAGE)) {
            return;
        }
        this.selectedItem = item;
        this.selectedItem.setState(true);
        this.selectedItem.setSelected(true);
        this.actionBox.updateFields((XmlTreeObject)item.getUserObject());
        this.hide();
    }

    public XmlTreeObject getCurrentSelected() {
        if (this.selectedItem != null) {
            return (XmlTreeObject)this.selectedItem.getUserObject();
        }
        return null;
    }

    public XmlTreeObject getCurrentSelectedParent() {
        XmlTreeObject currSelected = this.getCurrentSelected();
        if (currSelected instanceof MatchedItemTreeObject) {
            return ((MatchedItemTreeObject)currSelected).getParent();
        }
        return null;
    }
}

