/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleOperator;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationCriteriaPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.List;

public class ValidationCriteriaListingPanel
extends CriteriaListingPanel {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private TextBoxWidget actionText;
    private ListBoxWidget<UIAction> actionsList;
    private ValidationCriteriaPanel parentPanel;
    private static List<UIAction> actions;

    public ValidationCriteriaListingPanel(ValidationCriteriaPanel parentPanel) {
        super(RulesComponent.getInstance().getSpecification());
        this.searchOperatorType = new TitleOperator();
        this.actionText = new TextBoxWidget();
        this.parentPanel = parentPanel;
        this.putTheUiTogether(null);
    }

    public ValidationCriteriaListingPanel(IUITitleFilterNode condition, UIAction action, ValidationCriteriaPanel parentPanel) {
        super(RulesComponent.getInstance().getSpecification());
        this.searchOperatorType = new TitleOperator();
        this.actionText = new TextBoxWidget();
        this.parentPanel = parentPanel;
        this.putTheUiTogether(condition);
        this.setActionSelected(action);
    }

    private void putTheUiTogether(IUITitleFilterNode condition) {
        this.initializeActionDropDown();
        this.add((Widget)super.getWarningMessageBox());
        this.add((Widget)new LabelWidget(this.myConstants.validationActionLabel()));
        this.initializeTree(condition, 2);
        HorizontalContainer messageRow = new HorizontalContainer();
        messageRow.add((Widget)new LabelWidget(String.valueOf(this.myConstants.returnThis()) + " "));
        messageRow.add(this.actionsList);
        messageRow.add((Widget)new LabelWidget(String.valueOf(this.myConstants.message()) + " "));
        messageRow.add((Widget)this.actionText);
        ButtonWidget delButton = this.deleteButton();
        this.add((Widget)messageRow);
        this.add((Widget)delButton);
        this.setStyleName("validation-criteria-panel");
        this.setCellHorizontalAlignment((Widget)delButton, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    private void initializeActionDropDown() {
        this.actionsList = new ListBoxWidget();
        for (UIAction action : actions) {
            String label = this.myConstants.getString(action.getLabelKey());
            this.actionsList.addItem(label, (Object)action);
        }
    }

    private void setActionSelected(UIAction action) {
        if (action.containsParam(ActionParams.MESSAGE)) {
            UIActionParam param = action.getParam(ActionParams.MESSAGE);
            this.actionText.setText(param.getValue().getStringValue());
        }
        this.actionsList.setSelectedItem((Object)action);
    }

    public List<UIAction> getActions() {
        UIAction action = ((UIAction)this.actionsList.getSelectedItem()).clone();
        if (action.containsParam(ActionParams.MESSAGE)) {
            UIActionParam param = action.getParam(ActionParams.MESSAGE);
            param.getValue().setStringValue(this.actionText.getText());
        }
        ArrayList<UIAction> actions = new ArrayList<UIAction>();
        actions.add(action);
        return actions;
    }

    private ButtonWidget deleteButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationCriteriaListingPanel panel = ValidationCriteriaListingPanel.this;
                panel.parentPanel.removeRule(panel);
            }
        });
        button.addStyleDependentName("dataloss-button");
        return button;
    }

    public boolean validate() {
        boolean result = super.validate();
        if (this.actionText.getText().equals("")) {
            this.addWarningMessage(this.myConstants.ruleValidationBlankMessage());
            this.actionText.addStyleName("pinkbox");
            this.actionText.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ValidationCriteriaListingPanel.this.clearWarningMessages();
                    if (ValidationCriteriaListingPanel.this.actionText.getText().equals("")) {
                        ValidationCriteriaListingPanel.this.addWarningMessage(ValidationCriteriaListingPanel.this.myConstants.ruleValidationBlankMessage());
                        ValidationCriteriaListingPanel.this.actionText.addStyleName("pinkbox");
                    } else {
                        ValidationCriteriaListingPanel.this.actionText.addStyleName("whitebox");
                    }
                }
            });
            result = false;
        }
        return result;
    }

    public static void setCachedActions(List<UIAction> cachedActions) {
        actions = cachedActions;
    }

    public static boolean cacheLoaded() {
        return actions != null;
    }
}

