/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.validation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRule;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.validation.RulePanelHelper;
import com.tandbergtv.cms.rules.ui.client.validation.ValidationCriteriaListingPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class ValidationCriteriaPanel
extends VerticalContainer
implements Validatable {
    private List<ValidationCriteriaListingPanel> validationPanels = new ArrayList<ValidationCriteriaListingPanel>();
    private VerticalContainer rulesContainer;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);

    public ValidationCriteriaPanel(UIRuleSet ruleSet) {
        this.rulesContainer = new VerticalContainer();
        this.retrievePanels(ruleSet);
        this.populateUi();
    }

    public void removeRule(ValidationCriteriaListingPanel validationPanel) {
        this.validationPanels.remove((Object)validationPanel);
        this.rulesContainer.remove((Widget)validationPanel);
    }

    private void populateUi() {
        for (CriteriaListingPanel criteriaListingPanel : this.validationPanels) {
            this.rulesContainer.add((Widget)criteriaListingPanel);
        }
        this.add((Widget)this.rulesContainer);
        this.add((Widget)this.createButton(this.myConstants.createRuleButtonLabel()));
    }

    private void retrievePanels(UIRuleSet ruleSet) {
        for (UIRule rule : ruleSet.getRules()) {
            if (rule.getActions().size() != 1) continue;
            UIAction action = rule.getActions().get(0);
            this.validationPanels.add(new ValidationCriteriaListingPanel(rule.getUiTitleFilterNode(), action, this));
        }
    }

    private ButtonWidget createButton(String buttonName) {
        ButtonWidget button = new ButtonWidget(buttonName, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValidationCriteriaListingPanel panel = new ValidationCriteriaListingPanel(ValidationCriteriaPanel.this);
                ValidationCriteriaPanel.this.validationPanels.add(panel);
                ValidationCriteriaPanel.this.rulesContainer.add((Widget)panel);
            }
        });
        button.addStyleDependentName("action-button");
        button.addStyleName("rule-createRuleButton");
        return button;
    }

    public List<UIRule> getRules() {
        ArrayList<UIRule> result = new ArrayList<UIRule>();
        for (ValidationCriteriaListingPanel panel : this.validationPanels) {
            PredicateList row = panel.getRoot();
            if (!row.isVisible()) continue;
            UITitleFilterListNode tree = new UITitleFilterListNode();
            RulePanelHelper.populateTree(tree, row);
            UIRule rule = new UIRule(tree, panel.getActions());
            result.add(rule);
        }
        return result;
    }

    public List<PredicateRowBase> getListFromPanels() {
        ArrayList<PredicateRowBase> list = new ArrayList<PredicateRowBase>();
        for (CriteriaListingPanel criteriaListingPanel : this.validationPanels) {
            list.add((PredicateRowBase)criteriaListingPanel.getRoot());
        }
        return list;
    }

    public boolean validate() {
        for (ValidationCriteriaListingPanel panel : this.validationPanels) {
            if (panel.validate()) continue;
            return false;
        }
        return true;
    }
}

