/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.Node;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.TitleMetadataOptionProvider;
import com.ericsson.cms.scheduler.WOSchedulerCallback;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.TemplateVariable;
import com.ericsson.cms.scheduler.entities.WOJob;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import org.hibernate.Query;
import org.hibernate.Session;

@Stateless
@TransactionAttribute
public class WOScheduler
implements IWOScheduler {
    private static final String VAR_TITLEID = "titleId";
    @EJB
    private IScheduler scheduler;

    public List<IWOSchedulerClient> getAllClients() {
        ArrayList<IWOSchedulerClient> clients = new ArrayList<IWOSchedulerClient>();
        ServiceLoader<IWOSchedulerClient> loader = ServiceLoader.load(IWOSchedulerClient.class);
        Iterator<IWOSchedulerClient> serviceIterator = loader.iterator();
        if (serviceIterator != null) {
            while (serviceIterator.hasNext()) {
                clients.add(serviceIterator.next());
            }
        }
        return clients;
    }

    public IWOSchedulerClient getClientByName(String name) {
        ServiceLoader<IWOSchedulerClient> loader = ServiceLoader.load(IWOSchedulerClient.class);
        Iterator<IWOSchedulerClient> serviceIterator = loader.iterator();
        if (serviceIterator != null) {
            while (serviceIterator.hasNext()) {
                IWOSchedulerClient service = serviceIterator.next();
                if (!service.getName().equals(name)) continue;
                return service;
            }
        }
        throw new SchedulerException("No workorder scheduler client found with name: " + name);
    }

    public List<Node> getParametersForFilter(String clientName) {
        IWOSchedulerClient client = this.getClientByName(clientName);
        List filterParams = client.getParametersForFilter();
        return filterParams != null ? filterParams : new ArrayList(0);
    }

    public List<Node> getParametersForWorkOrderMapping(String clientName, boolean associatedWithTitles) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        IWOSchedulerClient client = this.getClientByName(clientName);
        List woParams = client.getParametersForWorkOrderMapping(associatedWithTitles);
        if (woParams != null) {
            allNodes.addAll(woParams);
        }
        if (associatedWithTitles) {
            allNodes.add(TitleMetadataOptionProvider.getJobParameterMenuOptions());
        }
        Node general = new Node("General");
        general.addChild(new Node("Job Execution Date"));
        allNodes.add(general);
        return allNodes;
    }

    public List<String> getTemplates() {
        ArrayList<String> templateNames = new ArrayList<String>();
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        if (service == null) {
            throw new SchedulerException("Unable to get ITitleTemplateProvider service");
        }
        Collection allTitleTemplates = service.getTemplates();
        if (allTitleTemplates != null) {
            for (WorkflowTemplate template : allTitleTemplates) {
                templateNames.add(template.getName());
            }
        }
        return templateNames;
    }

    public List<TemplateVariable> getTemplateStartParamNames(String templateName) {
        ArrayList<TemplateVariable> templateVariables = new ArrayList<TemplateVariable>();
        WorkflowTemplate matchedTemplate = null;
        ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
        if (service == null) {
            throw new SchedulerException("Unable to get ITitleTemplateProvider service");
        }
        Collection allTitleTemplates = service.getTemplates();
        if (allTitleTemplates != null) {
            for (WorkflowTemplate template : allTitleTemplates) {
                if (!templateName.equals(template.getName())) continue;
                matchedTemplate = template;
                break;
            }
        }
        if (matchedTemplate == null) {
            throw new SchedulerException("No template found with name: " + templateName);
        }
        for (TaskVariable variable : matchedTemplate.getStartTaskVariables()) {
            TemplateVariable templateVariable = new TemplateVariable(variable.getVariableName(), variable.getMappedName(), variable.isRequired());
            if (VAR_TITLEID.equals(variable.getVariableName())) {
                templateVariable.setAutoMapped(true);
            }
            templateVariables.add(templateVariable);
        }
        Collections.sort(templateVariables, new Comparator<TemplateVariable>(){

            @Override
            public int compare(TemplateVariable o1, TemplateVariable o2) {
                return o1.isRequired() ? -1 : 1;
            }
        });
        return templateVariables;
    }

    public List<WOJob> getAllSchedules() {
        String queryStr = "from WOJob";
        Query query = this.getSession().createQuery(queryStr);
        List woJobs = query.list();
        if (woJobs != null) {
            for (WOJob woJob : woJobs) {
                this.fillWithJobInfo(woJob);
            }
        }
        return woJobs;
    }

    public WOJob getSchedule(long id) {
        WOJob woJob = this.get(id);
        this.fillWithJobInfo(woJob);
        return woJob;
    }

    public WOJob getScheduleByJobId(long jobId) {
        String queryStr = "from WOJob where jobId = :jobId";
        Query query = this.getSession().createQuery(queryStr);
        query.setParameter("jobId", (Object)jobId);
        WOJob woJob = (WOJob)query.uniqueResult();
        if (woJob != null) {
            this.fillWithJobInfo(woJob);
        }
        return woJob;
    }

    public List<WOJob> getSchedulesByAssociatedEntityType(String entityType) {
        ArrayList<WOJob> woJobs = new ArrayList<WOJob>();
        List jobs = this.scheduler.getJobsByAssociatedEntityType(entityType);
        for (Job job : jobs) {
            WOJob woJob = this.getScheduleByJobId(job.getId());
            if (woJob == null) continue;
            woJobs.add(woJob);
        }
        return woJobs;
    }

    public List<WOJob> getSchedulesByAssociatedEntity(String entityType, long entityId) {
        ArrayList<WOJob> woJobs = new ArrayList<WOJob>();
        List jobs = this.scheduler.getJobsByAssociatedEntity(entityType, entityId);
        for (Job job : jobs) {
            WOJob woJob = this.getScheduleByJobId(job.getId());
            if (woJob == null) continue;
            woJobs.add(woJob);
        }
        return woJobs;
    }

    public WOJob schedule(WOJob woJob) {
        Job job;
        boolean create = woJob.getId() == null;
        WOJob dbWOJob = null;
        if (create) {
            job = new Job();
        } else {
            dbWOJob = this.get(woJob.getId());
            job = this.scheduler.get(dbWOJob.getJobId().longValue());
            dbWOJob.setTemplateName(woJob.getTemplateName());
            dbWOJob.setPriority(woJob.getPriority());
            dbWOJob.setWoMappingParams(woJob.getWoMappingParams());
        }
        job.setRule(woJob.getRule());
        job.setName(woJob.getName());
        job.setAssociatedEntityType(woJob.getAssociatedEntityType());
        job.setAssociatedEntities(woJob.getAssociatedEntities());
        job.setAssociationDescription(this.stringify(woJob.getAssociatedEntityType(), woJob.getAssociatedEntities()));
        job.setCallbackClass(WOSchedulerCallback.class);
        this.scheduler.schedule(job);
        if (create) {
            woJob.setJobId(job.getId());
            this.getSession().saveOrUpdate((Object)woJob);
            return woJob;
        }
        this.getSession().saveOrUpdate((Object)dbWOJob);
        return dbWOJob;
    }

    private String stringify(String type, Set<Long> entities) {
        String str = type;
        if (entities != null && !entities.isEmpty()) {
            str = str + ": " + entities.toString();
        }
        if (str.length() > 30) {
            str = str.substring(0, 27) + "...";
        }
        return str;
    }

    public void setScheduleActive(long woJobId, boolean active) {
        WOJob woJob = this.get(woJobId);
        this.scheduler.setActive(woJob.getJobId().longValue(), active);
    }

    public void setSchedulesActive(Set<Long> woJobIds, boolean active) {
        if (woJobIds != null) {
            for (Long woJobId : woJobIds) {
                if (woJobId == null) continue;
                this.setScheduleActive(woJobId, active);
            }
        }
    }

    public void dissociate(long woJobId, long entityId) {
        WOJob woJob = this.getSchedule(woJobId);
        if (woJob.getAssociatedEntities() == null || !woJob.getAssociatedEntities().contains(entityId)) {
            throw new SchedulerException("The Schedule is not associated with the given entity");
        }
        if (woJob.getAssociatedEntities().size() > 1) {
            this.scheduler.dissociate(woJob.getJobId().longValue(), entityId);
        } else {
            this.deleteSchedule(woJobId);
        }
    }

    public void deleteSchedule(long id) {
        WOJob woJob = this.get(id);
        this.getSession().delete((Object)woJob);
        this.scheduler.delete(woJob.getJobId().longValue());
    }

    public void deleteSchedules(Set<Long> woJobIds) {
        if (woJobIds != null) {
            for (Long woJobId : woJobIds) {
                if (woJobId == null) continue;
                this.deleteSchedule(woJobId);
            }
        }
    }

    private WOJob get(long id) {
        WOJob woJob = (WOJob)this.getSession().get(WOJob.class, (Serializable)Long.valueOf(id));
        if (woJob == null) {
            throw new SchedulerException("No workorder job found with id: " + id);
        }
        return woJob;
    }

    private void fillWithJobInfo(WOJob woJob) {
        Job job = this.scheduler.get(woJob.getJobId().longValue());
        woJob.setName(job.getName());
        woJob.setRule(job.getRule());
        woJob.setAssociatedEntityType(job.getAssociatedEntityType());
        woJob.setAssociatedEntities(job.getAssociatedEntities());
        woJob.setActive(job.isActive());
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

