/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.ActionContext;
import com.ericsson.cms.scheduler.ExecutionContext;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.cms.scheduler.IWOScheduler;
import com.ericsson.cms.scheduler.IWOSchedulerClient;
import com.ericsson.cms.scheduler.entities.WOJob;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WOSchedulerCallback
implements ISchedulerCallback {
    private static final Logger logger = Logger.getLogger(WOSchedulerCallback.class);
    private static final String REFERENCE_PREFIX = "$";
    private static final String EXEC_DATE = "General.Job Execution Date";
    private static final String TITLE_METADATA_PREFIX = "Title Metadata.";
    private static final String TITLE_ID = "titleId";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performAction(long jobId, String associatedEntityType, Set<Long> associatedEntityIds, String filterName, Date filterValue, Date execDate) {
        logger.debug((Object)("WOSchedulerCallback: " + associatedEntityType + " | " + associatedEntityIds + " | " + filterName + " | " + filterValue + " | " + execDate));
        IWOSchedulerClient client = this.getWOScheduler().getClientByName(associatedEntityType);
        WOJob woJob = this.getWOScheduler().getScheduleByJobId(jobId);
        if (associatedEntityIds == null || associatedEntityIds.isEmpty()) {
            associatedEntityIds = new HashSet<Long>();
            associatedEntityIds.add(null);
        }
        if (filterName == null) {
            for (Long associatedEntityId : associatedEntityIds) {
                HashMap<String, String> variables = new HashMap<String, String>();
                if (woJob.getWoMappingParams() != null) {
                    Map clientParamValues = client.getParameterValuesForWorkOrderMapping(associatedEntityId);
                    for (Map.Entry entry : woJob.getWoMappingParams().entrySet()) {
                        String paramValue = null;
                        if (entry.getValue() != null) {
                            if (((String)entry.getValue()).startsWith(REFERENCE_PREFIX)) {
                                String reference = ((String)entry.getValue()).substring(REFERENCE_PREFIX.length());
                                if (reference.equals(EXEC_DATE)) {
                                    paramValue = DATE_FORMAT.format(execDate);
                                } else {
                                    if (clientParamValues == null || !clientParamValues.containsKey(reference)) throw new RuntimeException("Invalid workorder mapping reference parameter. WOJobId: " + woJob.getId() + " | Param Value: " + (String)entry.getValue());
                                    paramValue = (String)clientParamValues.get(reference);
                                }
                            } else {
                                paramValue = (String)entry.getValue();
                            }
                        }
                        variables.put((String)entry.getKey(), paramValue);
                    }
                }
                this.createWorkOrder(woJob.getTemplateName(), woJob.getPriority(), variables);
            }
            return;
        } else {
            for (Long associatedEntityId : associatedEntityIds) {
                ExecutionContext ec = client.getExecutionContext(associatedEntityId, filterName, filterValue);
                if (ec.getActionContexts() == null) continue;
                for (ActionContext ac : ec.getActionContexts()) {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    if (woJob.getWoMappingParams() != null) {
                        for (Map.Entry entry : woJob.getWoMappingParams().entrySet()) {
                            String paramValue = null;
                            if (((String)entry.getKey()).equals(TITLE_ID)) {
                                paramValue = Long.toString(ac.getTitle().getId());
                            } else if (entry.getValue() != null) {
                                if (((String)entry.getValue()).startsWith(REFERENCE_PREFIX)) {
                                    String reference = ((String)entry.getValue()).substring(REFERENCE_PREFIX.length());
                                    if (reference.equals(EXEC_DATE)) {
                                        paramValue = DATE_FORMAT.format(execDate);
                                    } else if (reference.startsWith(TITLE_METADATA_PREFIX)) {
                                        String titleReference = reference.substring(TITLE_METADATA_PREFIX.length());
                                        paramValue = this.evaluate(ac.getTitle(), titleReference);
                                    } else if (ac.getWorkOrderMappingParams() != null && ac.getWorkOrderMappingParams().containsKey(reference)) {
                                        paramValue = (String)ac.getWorkOrderMappingParams().get(reference);
                                    } else {
                                        if (ec.getCommonWOParams() == null || !ec.getCommonWOParams().containsKey(reference)) throw new RuntimeException("Invalid workorder mapping reference parameter. WOJobId: " + woJob.getId() + " | Param Value: " + (String)entry.getValue());
                                        paramValue = (String)ec.getCommonWOParams().get(reference);
                                    }
                                } else {
                                    paramValue = (String)entry.getValue();
                                }
                            }
                            variables.put((String)entry.getKey(), paramValue);
                        }
                    }
                    this.createWorkOrder(woJob.getTemplateName(), woJob.getPriority(), variables);
                }
            }
        }
    }

    private String evaluate(Title title, String titleReference) {
        int xpathDelimIndex = titleReference.lastIndexOf(46);
        String assetReference = titleReference.substring(0, xpathDelimIndex);
        String[] assetTypes = assetReference.split("\\.");
        List<String> assetTypesList = Arrays.asList(assetTypes);
        String xpath = titleReference.substring(xpathDelimIndex + 1);
        List fields = title.getAsset().getAllFieldsForXpath(assetTypesList, xpath);
        return ((Field)fields.get(0)).getValue();
    }

    private void createWorkOrder(String templateName, String priority, Map<String, String> variables) {
        MessageImpl message = null;
        try {
            WorkflowMessage workflowMessage = WorkflowMessageFactory.createControlMessage((String)"PM0111");
            WPCLCommand command = new WPCLCommand("create");
            command.addParameter("_template", templateName);
            if (!priority.equals("_rules")) {
                command.addParameter("priority", priority);
            }
            workflowMessage.setCommand(command);
            WorkflowPayload workflowPayload = workflowMessage.getPayload();
            for (Map.Entry<String, String> variable : variables.entrySet()) {
                workflowPayload.putValue(variable.getKey(), variable.getValue());
            }
            Document document = Marshaller.newMarshaller().marshal(workflowMessage);
            StringPayload strPayload = new StringPayload(XMLDocumentUtility.convertToString((Node)document));
            message = new MessageImpl((IPayload)strPayload, workflowMessage.getAttachment());
        }
        catch (Exception e) {
            logger.error((Object)"Exception when preparing create workorder message to workflow.", (Throwable)e);
            return;
        }
        try {
            IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
            router.send((IMessage)message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception when sending create workorder message to workflow.", (Throwable)e);
            return;
        }
    }

    private IWOScheduler getWOScheduler() {
        return (IWOScheduler)InjectionUtil.injectInstance((String)"/cms/WOScheduler/local", IWOScheduler.class);
    }
}

