/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.conf;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.util.PropertyFileReader;
import java.io.File;
import java.util.Map;

public class SchedulerPropertiesReader {
    private static final String CONFIG_DIR = "scheduler";
    private static final String CONFIG_FILE_NAME = "scheduler.properties";
    private static final String PROPERTY_NAME_LOOKUP_PERIOD_DAYS = "scheduler.nextnjobs.lookupPeriodDays";
    private static final String PROPERTY_NAME_MAX_LOOKUPS = "scheduler.nextnjobs.maxLookups";
    private static final int DEFAULT_LOOKUP_PERIOD_DAYS = 30;
    private static final int DEFAULT_MAX_LOOKUPS = 12;

    public static Map<String, String> getProperties() {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File uiConfig = configReaderService.getFile(CONFIG_DIR, CONFIG_FILE_NAME);
        return PropertyFileReader.readProperties((File)uiConfig);
    }

    public static int getLookupPeriodDays(Map<String, String> properties) {
        int lookupPeriodDays = 30;
        try {
            lookupPeriodDays = Integer.parseInt(properties.get(PROPERTY_NAME_LOOKUP_PERIOD_DAYS).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lookupPeriodDays;
    }

    public static int getMaxLookups(Map<String, String> properties) {
        int maxLookups = 12;
        try {
            maxLookups = Integer.parseInt(properties.get(PROPERTY_NAME_MAX_LOOKUPS).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxLookups;
    }
}

