/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core;

import com.ericsson.cms.sites.core.SiteManagementException;
import com.ericsson.cms.sites.core.entities.Site;
import java.util.ArrayList;
import java.util.List;

public class EntitiesAssociatedException
extends SiteManagementException {
    private static final long serialVersionUID = -5159014683450907334L;
    private Site site;
    private List<ErrorMessage> associatedEntities = new ArrayList<ErrorMessage>();

    public EntitiesAssociatedException(Site site) {
        this.site = site;
    }

    public void addAssociatedEntity(EntityType entityType) {
        this.associatedEntities.add(new ErrorMessage(entityType));
    }

    public void addAssociatedEntity(EntityType entityType, String msg) {
        this.associatedEntities.add(new ErrorMessage(entityType, msg));
    }

    public boolean hasEntities() {
        return !this.associatedEntities.isEmpty();
    }

    @Override
    public String getMessage() {
        return "There are associated entities: " + this.associatedEntities + " for site: [" + this.site + "]";
    }

    private class ErrorMessage {
        private EntityType entityType;
        private String message;

        public ErrorMessage(EntityType entityType) {
            this(entityType, "");
        }

        public ErrorMessage(EntityType entityType, String message) {
            this.entityType = entityType;
            this.message = message.isEmpty() ? "" : " (" + message + ")";
        }

        public String toString() {
            return this.entityType.toString() + this.message;
        }
    }

    public static enum EntityType {
        TITLES,
        RULES,
        JOBS;

    }
}

