/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="distributionSite")
public class DistributionSite
extends Site {
    private static final long serialVersionUID = -6462042194756033513L;
    private String metadataFormat;
    private String commaSeparatedFileLookupKeys;
    private DistributionOption distributionOption;
    private Integer alertDelayPeriod;
    private String distTemplateName;
    private Map<String, String> distConfParams;
    private Long associatedResourceId;
    private LogicalSite parent;
    private Set<TrackingSite> children;
    private Set<DistributionSiteTitle> distributionSiteTitles;

    public void setChildren(Set<TrackingSite> children) {
        this.children = children;
    }

    public void addChild(TrackingSite child) {
        if (this.children == null) {
            this.children = new HashSet<TrackingSite>();
        }
        this.children.add(child);
    }

    public boolean removeChild(TrackingSite child) {
        if (this.children != null) {
            return this.children.remove(child);
        }
        return false;
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    @XmlTransient
    public Set<TrackingSite> getChildren() {
        return this.children;
    }

    @Override
    @XmlTransient
    public Set<Site> getSiteChildren() {
        HashSet<Site> siteChildren = new HashSet<Site>();
        if (this.children != null) {
            for (TrackingSite trackingSiteChild : this.children) {
                siteChildren.add(trackingSiteChild);
            }
        }
        return siteChildren;
    }

    public void setParent(LogicalSite parent) {
        this.parent = parent;
    }

    @XmlTransient
    public LogicalSite getParent() {
        return this.parent;
    }

    @Override
    @XmlElement(nillable=true)
    public SiteType getType() {
        return SiteType.DISTRIBUTION;
    }

    @Override
    @XmlTransient
    public Set<Site> getSiteParents() {
        HashSet<Site> parents = new HashSet<Site>();
        if (this.parent != null) {
            parents.add(this.parent);
        }
        return parents;
    }

    @XmlTransient
    public Set<DistributionSiteTitle> getDistributionSiteTitles() {
        return this.distributionSiteTitles;
    }

    public DistributionSiteTitle getDistributionSiteTitle(long titleId) {
        if (this.distributionSiteTitles != null) {
            for (DistributionSiteTitle dst : this.distributionSiteTitles) {
                if (dst.getTitle().getId() != titleId) continue;
                return dst;
            }
        }
        return null;
    }

    public void setDistributionSiteTitles(Set<DistributionSiteTitle> distributionSiteTitles) {
        this.distributionSiteTitles = distributionSiteTitles;
    }

    @XmlElement(nillable=true)
    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    @XmlTransient
    public List<String> getFileLookupKeys() {
        if (this.commaSeparatedFileLookupKeys == null || this.commaSeparatedFileLookupKeys.isEmpty()) {
            return null;
        }
        String[] fileLookupKeysArray = this.commaSeparatedFileLookupKeys.split(",");
        return Arrays.asList(fileLookupKeysArray);
    }

    public void setFileLookupKeys(List<String> fileLookupKeys) {
        if (fileLookupKeys == null || fileLookupKeys.isEmpty()) {
            this.commaSeparatedFileLookupKeys = null;
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean firstTime = true;
        for (String key : fileLookupKeys) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(",");
            }
            sb.append(key);
        }
        this.commaSeparatedFileLookupKeys = sb.toString();
    }

    @XmlTransient
    protected String getCommaSeparatedFileLookupKeys() {
        return this.commaSeparatedFileLookupKeys;
    }

    protected void setCommaSeparatedFileLookupKeys(String commaSeparatedFileLookupKeys) {
        this.commaSeparatedFileLookupKeys = commaSeparatedFileLookupKeys;
    }

    @XmlElement(nillable=true)
    public DistributionOption getDistributionOption() {
        return this.distributionOption;
    }

    public void setDistributionOption(DistributionOption distributionOption) {
        this.distributionOption = distributionOption;
    }

    @XmlElement(nillable=true)
    public Integer getAlertDelayPeriod() {
        return this.alertDelayPeriod;
    }

    public void setAlertDelayPeriod(Integer alertDelayPeriod) {
        this.alertDelayPeriod = alertDelayPeriod;
    }

    public String getDistTemplateName() {
        return this.distTemplateName;
    }

    public void setDistTemplateName(String distTemplateName) {
        this.distTemplateName = distTemplateName;
    }

    @XmlTransient
    public Map<String, String> getDistConfParams() {
        return this.distConfParams;
    }

    public void setDistConfParams(Map<String, String> distConfParams) {
        this.distConfParams = distConfParams;
    }

    @XmlTransient
    public Long getAssociatedResourceId() {
        return this.associatedResourceId;
    }

    public void setAssociatedResourceId(Long associatedResourceId) {
        this.associatedResourceId = associatedResourceId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

